/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core.project;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.ModulePermissionConstants;
import com.arcway.cockpit.documentmodule.client.core.project.DocumentPermissionRootNode;
import com.arcway.cockpit.documentmodule.client.core.project.ModelController;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DCMDataTypesHelper;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class DocumentPermissionTemplateProvider
extends AbstractPermissionTemplateProvider {
    private static final HashMap categoryMap = new HashMap();
    private static final String CATEGORY_KEY = "Category";
    private static final String RESOURCE_LOCATOR_KEY = "ResourceLocator";
    private static final String PERMISSION_DIALOG_TAB_NAME = Messages.getString("Permissions.TabName");
    private static final String PERMISSION_DIALOG_TAB_DESCRIPTION = Messages.getString("Permissions.TabDescription");
    private static final String ROOT_LABEL = Messages.getString("Permissions.RootLabel");
    private static final String TreeViewerInput = "TreeViewerInput";

    public DocumentPermissionTemplateProvider() {
        super(DCMDataTypesHelper.getDefault());
    }

    public String getName() {
        return PERMISSION_DIALOG_TAB_NAME;
    }

    public String getDescription() {
        return PERMISSION_DIALOG_TAB_DESCRIPTION;
    }

    public Collection<ModulePermissionTemplate> getTemplates(IFrameProjectAgent projectAgent) {
        ArrayList<ModulePermissionTemplate> templates = new ArrayList<ModulePermissionTemplate>();
        templates.addAll(ModulePermissionConstants.getTemplates());
        return templates;
    }

    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        return new TemplateLabelProvider(projectAgent);
    }

    public Object getTreeViewerInput(IModuleProjectAgent projectAgent) {
        return TreeViewerInput;
    }

    public IPermissionOperandTreeContentProvider getTreeContentProvider(IModuleProjectAgent projectAgent) {
        return new TreeContentProvider(projectAgent);
    }

    public ILabelProvider getTreeLabelProvider(IModuleProjectAgent projectAgent) {
        return new TreeLabelProvider();
    }

    public ViewerSorter getTreeSorter() {
        return null;
    }

    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        if (template.getOperation().equals("dcm.createCategories") || template.getOperation().equals("dcm.editCategory")) {
            return null;
        }
        if (template instanceof AttributeModificationPermissionTemplate) {
            AttributeModificationPermissionTemplate attrTemplate = (AttributeModificationPermissionTemplate)template;
            if (attrTemplate.getCockpitDataTypeID().equals(CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForDocumentCategory();
            }
            if (attrTemplate.getCockpitDataTypeID().equals("dcm.filesystemlink") || attrTemplate.getCockpitDataTypeID().equals("dcm.weblink")) {
                return this.getCategoryForResourceLocator();
            }
        }
        return super.getCategory(projectAgent, template);
    }

    private IPermissionTemplateCategory getCategoryForDocumentCategory() {
        if (!categoryMap.containsKey(CATEGORY_KEY)) {
            categoryMap.put(CATEGORY_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return DocumentPermissionTemplateProvider.CATEGORY_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("DocumentPermissionTemplateProvider.CategoriesDisplayName");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(CATEGORY_KEY);
    }

    private IPermissionTemplateCategory getCategoryForResourceLocator() {
        if (!categoryMap.containsKey(RESOURCE_LOCATOR_KEY)) {
            categoryMap.put(RESOURCE_LOCATOR_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return DocumentPermissionTemplateProvider.RESOURCE_LOCATOR_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("DocumentPermissionTemplateProvider.RLDisplayName");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(RESOURCE_LOCATOR_KEY);
    }

    private static class TemplateLabelProvider
    extends AbstractPermissionTemplateProvider.AbstractTemplateLabelProvider {
        public TemplateLabelProvider(IFrameProjectAgent projectAgent) {
            super(projectAgent, DCMDataTypesHelper.getDefault());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            assert (element instanceof CockpitPermissionTemplate);
            CockpitPermissionTemplate template = (CockpitPermissionTemplate)element;
            return ModulePermissionConstants.getName(template);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class TreeContentProvider
    extends AbstractPermissionTemplateProvider.AbstractTreeContentProvider {
        private final DocumentPermissionRootNode rootNode = DocumentPermissionRootNode.ALL_CATEGORIES_INSTANCE;

        public TreeContentProvider(IModuleProjectAgent p_projectAgent) {
            super(p_projectAgent, ModuleIdentification.getModuleID());
        }

        private ModelController getDCMModelController() {
            return (ModelController)this.getModelController();
        }

        public IPermissionOperand[] getElements(Object input) {
            IPermissionOperand[] item = new IPermissionOperand[2];
            if (input.equals(DocumentPermissionTemplateProvider.TreeViewerInput)) {
                item[0] = this.getProjectAgent();
                item[1] = DocumentPermissionRootNode.ALL_CATEGORIES_INSTANCE;
            }
            return item;
        }

        public IPermissionOperand getTreeRootNode() {
            return DocumentPermissionRootNode.ALL_CATEGORIES_INSTANCE;
        }

        public boolean hasChildren(IPermissionOperand element) {
            boolean hasChildren = false;
            if (element instanceof DocumentPermissionRootNode) {
                hasChildren = !this.getModelController().getAllItems("dcm.category").isEmpty();
            } else if (element instanceof IModuleProjectAgent) {
                hasChildren = false;
            } else if (element instanceof Category) {
                hasChildren = false;
            }
            return hasChildren;
        }

        public IPermissionOperand getParent(IPermissionOperand element) {
            IPermissionOperand parent;
            if (element instanceof DocumentPermissionRootNode) {
                parent = null;
            } else if (element instanceof IModuleProjectAgent) {
                parent = null;
            } else if (element instanceof Category) {
                parent = this.rootNode;
            } else if (element instanceof DocumentContainer) {
                DocumentContainer container = (DocumentContainer)element;
                Category category = this.getDCMModelController().getCategory(container);
                parent = category;
            } else if (element instanceof ResourceLocator) {
                ResourceLocator resource = (ResourceLocator)element;
                DocumentContainer container = (DocumentContainer)this.getModelController().getParent((IModuleData)resource);
                Category category = this.getDCMModelController().getCategory(container);
                parent = category;
            } else {
                parent = null;
            }
            return parent;
        }

        public IPermissionOperand[] getChildren(IPermissionOperand parentElement) {
            Collection children = parentElement instanceof DocumentPermissionRootNode ? this.getModelController().getAllItems("dcm.category") : (parentElement instanceof Collection ? (Collection)parentElement : (parentElement instanceof IModuleProjectAgent ? Collections.EMPTY_SET : (parentElement instanceof Category ? Collections.EMPTY_SET : Collections.EMPTY_SET)));
            IPermissionOperand[] childrenArray = new IPermissionOperand[children.size()];
            children.toArray(childrenArray);
            return childrenArray;
        }
    }

    private static class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof Category) {
                ImageDescriptor desc = DocumentModulePlugin.getImageDescriptor("Category.gif");
                return DocumentModulePlugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            if (element instanceof IModuleProjectAgent) {
                ImageDescriptor desc = DocumentModulePlugin.getImageDescriptor("documents.gif");
                return DocumentModulePlugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            if (element instanceof DocumentPermissionRootNode) {
                ImageDescriptor desc = DocumentModulePlugin.getImageDescriptor("Category.gif");
                return DocumentModulePlugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DocumentPermissionRootNode) {
                return Messages.getString("DocumentPermissionTemplateProvider.EditContainer");
            }
            if (element instanceof Category) {
                return ((Category)((Object)element)).getName().getDisplayStringRepresentation();
            }
            if (element instanceof DocumentContainer) {
                return ((DocumentContainer)element).getName().getDisplayStringRepresentation();
            }
            if (element instanceof IModuleProjectAgent) {
                return ROOT_LABEL;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

