/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.shared.messages;

import com.arcway.cockpit.modulelib2.shared.messages.AbstractLinkTypeHelper_Shared;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DCMLinkTypeHelper_Shared
extends AbstractLinkTypeHelper_Shared {
    public static final String LTID_CONTAINER_CATEGORY = "ContainerCategory";
    public static final String LTID_FILELINK_DOCCONTAINER = "FilelinkDocumentContainer";
    public static final String LTID_WEBLINK_DOCCONTAINER = "WeblinkDocumentContainer";
    public static final String LTID_DOCCONTAINER_UE = "DocumentContainerUE";
    public static final String LTID_DOCCONTAINER_SECTION = DCMLinkTypeHelper_Shared.getDefault().getSectionLinkTypeID("dcm.category");
    private static ILinkTypeHelper_Shared singleton;

    private DCMLinkTypeHelper_Shared() {
    }

    public static ILinkTypeHelper_Shared getDefault() {
        if (singleton == null) {
            singleton = new DCMLinkTypeHelper_Shared();
        }
        return singleton;
    }

    protected String getModuleDataDataTypeIDForLinkType_(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        if (linkTypeID.equals(LTID_CONTAINER_CATEGORY)) {
            return "dcm.documentcontainer";
        }
        if (linkTypeID.equals(LTID_FILELINK_DOCCONTAINER)) {
            return "dcm.filesystemlink";
        }
        if (linkTypeID.equals(LTID_WEBLINK_DOCCONTAINER)) {
            return "dcm.weblink";
        }
        if (linkTypeID.equals(LTID_DOCCONTAINER_UE)) {
            return "dcm.documentcontainer";
        }
        return null;
    }

    protected String getLinkableObjectDataTypeIDForLinkType_(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        if (linkTypeID.equals(LTID_CONTAINER_CATEGORY)) {
            return "dcm.category";
        }
        if (linkTypeID.equals(LTID_FILELINK_DOCCONTAINER)) {
            return "dcm.documentcontainer";
        }
        if (linkTypeID.equals(LTID_WEBLINK_DOCCONTAINER)) {
            return "dcm.documentcontainer";
        }
        return null;
    }

    public Collection getLinkTypeIDsForModuleDataDataType(String dataTypeUID) {
        List<Object> linkTypeIDs_;
        assert (dataTypeUID != null) : "dataTypeUID must not be null";
        if (dataTypeUID.equals("dcm.documentcontainer")) {
            String[] newLinkTypeIDs = new String[]{LTID_CONTAINER_CATEGORY, LTID_DOCCONTAINER_UE};
            linkTypeIDs_ = Arrays.asList(newLinkTypeIDs);
        } else if (dataTypeUID.equals("dcm.filesystemlink")) {
            String[] newLinkTypeIDs = new String[]{LTID_FILELINK_DOCCONTAINER};
            linkTypeIDs_ = Arrays.asList(newLinkTypeIDs);
        } else if (dataTypeUID.equals("dcm.documentcontainer")) {
            String[] newLinkTypeIDs = new String[]{LTID_WEBLINK_DOCCONTAINER};
            linkTypeIDs_ = Arrays.asList(newLinkTypeIDs);
        } else {
            linkTypeIDs_ = new ArrayList();
        }
        return new ArrayList(linkTypeIDs_);
    }

    public Collection getLinkTypeIDsForLinkableObjectDataType(String dataTypeUID) {
        List<Object> linkTypeIDs_;
        assert (dataTypeUID != null) : "dataTypeUID must not be null";
        if (dataTypeUID.equals("dcm.category")) {
            String[] newLinkTypeIDs = new String[]{LTID_CONTAINER_CATEGORY};
            linkTypeIDs_ = Arrays.asList(newLinkTypeIDs);
        } else if (dataTypeUID.equals("dcm.documentcontainer")) {
            String[] newLinkTypeIDs = new String[]{LTID_FILELINK_DOCCONTAINER, LTID_WEBLINK_DOCCONTAINER};
            linkTypeIDs_ = Arrays.asList(newLinkTypeIDs);
        } else {
            linkTypeIDs_ = new ArrayList();
        }
        return new ArrayList(linkTypeIDs_);
    }

    public String getHierarchyLinkTypeID(String parentTypeID, String childTypeID) {
        if (parentTypeID.equals("dcm.category") && childTypeID.equals("dcm.documentcontainer")) {
            return LTID_CONTAINER_CATEGORY;
        }
        if (parentTypeID.equals("dcm.documentcontainer") && childTypeID.equals("dcm.weblink")) {
            return LTID_WEBLINK_DOCCONTAINER;
        }
        if (parentTypeID.equals("dcm.documentcontainer") && childTypeID.equals("dcm.filesystemlink")) {
            return LTID_FILELINK_DOCCONTAINER;
        }
        return null;
    }

    public boolean isUELinkType(String linkTypeID) {
        return linkTypeID.equals(LTID_DOCCONTAINER_UE);
    }

    public boolean isLELinkType(String linkTypeID) {
        return false;
    }

    public String getModelElementLinkTypeIDForModuleDataDataType(String dataTypeUID) {
        if (dataTypeUID.equals("dcm.documentcontainer")) {
            return LTID_DOCCONTAINER_UE;
        }
        return null;
    }
}

