/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.writer.AbstractDocumentationWriter;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractDocumentationWriterWithProgress
extends AbstractDocumentationWriter {
    private static final ILogger logger = Logger.getLogger(AbstractDocumentationWriterWithProgress.class);
    private boolean threadable = false;
    private boolean cancelable = false;

    public AbstractDocumentationWriterWithProgress(boolean threadable, boolean cancelable) {
        this.threadable = threadable;
        this.cancelable = cancelable;
    }

    @Override
    public final void postProcess(final VelocityReportJob reportJob, final IWorkbenchPage workbenchPage) throws ReportGenerationException {
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    Thread watchDogThread;
                    final int timeoutInSeconds = reportJob.getTimeoutInSeconds();
                    if (timeoutInSeconds > 0) {
                        final Thread currentThread = Thread.currentThread();
                        Runnable watchDog = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    try {
                                        this.wait(1000 * timeoutInSeconds);
                                        logger.error("Timeout - cancellation of report generation after " + timeoutInSeconds + " seconds");
                                        System.exit(99);
                                        currentThread.stop();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                        };
                        watchDogThread = new Thread(watchDog, String.valueOf(currentThread.getName()) + " Watchdog");
                        watchDogThread.start();
                    } else {
                        watchDogThread = null;
                    }
                    AbstractDocumentationWriterWithProgress.this.postProcessWithProgress(reportJob, workbenchPage, monitor);
                    if (watchDogThread != null) {
                        watchDogThread.interrupt();
                    }
                }
                catch (ReportGenerationException rgE) {
                    throw new InvocationTargetException(rgE);
                }
            }
        };
        boolean hasBeenCanceled = false;
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(new Shell());
        try {
            pmd.run(this.threadable, this.cancelable, rwp);
        }
        catch (InvocationTargetException e1) {
            if (e1.getTargetException() instanceof ReportGenerationException) {
                throw (ReportGenerationException)e1.getTargetException();
            }
            String title = Messages.getString("ReportGenerator.UnknownExceptionTitle");
            String message = Messages.getString("ReportGenerator.UnknownExceptionMessage");
            throw new ReportGenerationException(title, message, (Throwable)e1);
        }
        catch (InterruptedException e1) {
            hasBeenCanceled = true;
        }
        if (hasBeenCanceled || pmd.getProgressMonitor().isCanceled()) {
            logger.info("Report generation canceled by the user");
            this.postprocessingInterrupted(reportJob);
        }
    }

    protected abstract void postProcessWithProgress(VelocityReportJob var1, IWorkbenchPage var2, IProgressMonitor var3) throws ReportGenerationCanceledException, ReportGenerationException;

    protected abstract void postprocessingInterrupted(VelocityReportJob var1);
}

