/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.planagent;

import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.planagent.AbstractGraphicAdapter;
import com.arcway.cockpit.docgen.provider.planagent.ForcedViewRectangle;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import de.plans.lib.svg.ILink;
import de.plans.lib.svg.SVGPrinter;
import java.io.File;
import java.util.Map;

public class SVGGraphicsAdapter
extends AbstractGraphicAdapter {
    private SVGPrinter printer = null;

    @Override
    public Dimension export(PlanImageSizeHint preferredSize, IGraphicProvider graphicProvider, Map<String, String> classIDMap, String styleSheetFilename, Map<String, ILink> linkMap, ForcedViewRectangle forcedViewRectangle) throws PrintingFailure, EXEmptyResult {
        PageSetup pageSetup;
        boolean proceedIfPlanIsEmpty = false;
        Dimension planSizeInMM = SVGGraphicsAdapter.getPlanSizeInMM(graphicProvider, forcedViewRectangle, proceedIfPlanIsEmpty);
        Dimension limitedPlanSizeInMM = SVGGraphicsAdapter.calculateLimitedPlanSize(planSizeInMM, preferredSize);
        double inset = 0.0;
        IPageDescription printInfo = PageDescription.createPrintInfoInMM((double)limitedPlanSizeInMM.width, (double)limitedPlanSizeInMM.height, (double)inset);
        this.printer = new SVGPrinter(printInfo, false, classIDMap, styleSheetFilename, linkMap);
        int pageCountX = 1;
        int pageCountY = 1;
        Insets insets = new Insets(inset);
        if (forcedViewRectangle == null || forcedViewRectangle.getZoom() == null) {
            Alignment alignment = new Alignment();
            double zoom = 1.0;
            boolean fitHorizontal = true;
            boolean fitVertical = true;
            pageSetup = new PageSetup(pageCountX, pageCountY, alignment, zoom, fitHorizontal, fitVertical, insets);
        } else {
            Alignment alignment = new Alignment(1, 8);
            double zoom = forcedViewRectangle.getZoom();
            boolean fitHorizontal = false;
            boolean fitVertical = false;
            double offsetX = forcedViewRectangle.getOffsetX();
            double offsetY = forcedViewRectangle.getOffsetY();
            pageSetup = new PageSetup(pageCountX, pageCountY, alignment, zoom, fitHorizontal, fitVertical, insets, offsetX, offsetY);
        }
        graphicProvider.export((IPrinter)this.printer, pageSetup);
        return limitedPlanSizeInMM;
    }

    @Override
    public void save(File imageFile) throws PrintingFailure, EXEmptyResult {
        File imageDirectory = imageFile.getParentFile();
        this.printer.saveSVGDirectly(imageDirectory, imageFile.getName());
    }

    @Override
    public void disposeImages() {
        this.printer.disposeImages();
    }
}

