/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.graphicsandfiles;

import com.arcway.lib.geometry.Dimension;

public class PlanImageSizeHint {
    private static final int UNIT_OF_MEASURE_MM = 0;
    private static final int UNIT_OF_MEASURE_PIXEL = 1;
    private static final int UNIT_OF_MEASURE_POINT = 2;
    private static final int UNIT_OF_MEASURE_INCH = 3;
    private final Dimension wishedDimension;
    private final int unit;
    private final double resolution;

    public static PlanImageSizeHint getSizeHintInMM(Dimension wishedDimension, double resolution) {
        return new PlanImageSizeHint(wishedDimension, 0, resolution);
    }

    public static PlanImageSizeHint getSizeHintInPixel(Dimension wishedDimension, double resolution) {
        return new PlanImageSizeHint(wishedDimension, 1, resolution);
    }

    public static PlanImageSizeHint getSizeHintInPoint(Dimension wishedDimension, double resolution) {
        return new PlanImageSizeHint(wishedDimension, 2, resolution);
    }

    public static PlanImageSizeHint getSizeHintInInch(Dimension wishedDimension, double resolution) {
        return new PlanImageSizeHint(wishedDimension, 3, resolution);
    }

    private PlanImageSizeHint(Dimension wishedDimension, int unit, double resolution) {
        this.wishedDimension = wishedDimension;
        this.unit = unit;
        this.resolution = resolution;
    }

    private Dimension getWishedDimension() {
        return this.wishedDimension;
    }

    private int getUnit() {
        return this.unit;
    }

    public double getResolution() {
        return this.resolution;
    }

    public Dimension getPreferredSizeInMM() {
        double widthMM = 0.0;
        double heightMM = 0.0;
        switch (this.getUnit()) {
            case 0: {
                widthMM = this.getWishedDimension().width;
                heightMM = this.getWishedDimension().height;
                break;
            }
            case 1: {
                widthMM = this.getWishedDimension().width / this.resolution * 25.4;
                heightMM = this.getWishedDimension().height / this.resolution * 25.4;
                break;
            }
            case 3: {
                widthMM = this.getWishedDimension().width * 25.4;
                heightMM = this.getWishedDimension().width * 25.4;
                break;
            }
            case 2: {
                widthMM = this.getWishedDimension().width / 72.0 * 25.4;
                heightMM = this.getWishedDimension().height / 72.0 * 25.4;
                break;
            }
            default: {
                widthMM = this.getWishedDimension().width;
                heightMM = this.getWishedDimension().height;
            }
        }
        return new Dimension(widthMM, heightMM);
    }

    public double getPreferredWidthInMM() {
        return this.getPreferredSizeInMM().width;
    }

    public double getPreferredHeightInMM() {
        return this.getPreferredSizeInMM().height;
    }
}

