/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOColSpec;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEntry;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.docbook.model.EORow;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTBody;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTFoot;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTGroup;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTHead;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.ReportTemplateHeaders;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.EmphasisWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.LinkWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.PhraseWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.UlinkWriter;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.lib.eclipse.ole.word.Borders;
import com.arcway.lib.eclipse.ole.word.Cell;
import com.arcway.lib.eclipse.ole.word.Cells;
import com.arcway.lib.eclipse.ole.word.Column;
import com.arcway.lib.eclipse.ole.word.Columns;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Paragraphs;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.Row;
import com.arcway.lib.eclipse.ole.word.Rows;
import com.arcway.lib.eclipse.ole.word.Table;
import com.arcway.lib.eclipse.ole.word.Tables;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class TableWriter {
    private static final ILogger logger = Logger.getLogger(TableWriter.class);
    public static final String TEMPLATE_HEADER_NO_EMPTY_LINES_AFTER_WORD_TABLES = "noEmptyLineAfterWordTables";
    public static final String TEMPLATE_HEADER_NO_EMPTY_LINE_AT_END_OF_WORD_TABLE_CELLS = "noEmptyLineAtEndOfWordTableCells";
    private static TableWriter writer;

    public static TableWriter getInstance() {
        if (writer == null) {
            writer = new TableWriter();
        }
        return writer;
    }

    private TableWriter() {
    }

    public void write(EOTable eotable, Paragraph para, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        Range range = para.get_Range();
        ReportJob reportJob = processingContext.getReportJob();
        boolean noEmptyLineAfterWordTables = ReportTemplateHeaders.isHeaderParameterTrue((Map)reportJob.getReportTemplateHeader(), (String)TEMPLATE_HEADER_NO_EMPTY_LINES_AFTER_WORD_TABLES);
        range.set_End(range.get_End() - (noEmptyLineAfterWordTables ? 0 : 1));
        if (logger.isDebugEnabled(150)) {
            logger.debug(150, "[write table] got  range object ");
        }
        this.write(eotable, range, document, styleMap, graphicsAndFilesStore, processingContext);
    }

    public void write(EOTable eotable, Range range, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        int numberBodyRows;
        List tgroupList = eotable.getTGroup();
        EOTGroup tgroup = (EOTGroup)tgroupList.get(0);
        EOTHead tHead = tgroup.getTableHead();
        EOTBody tBody = tgroup.getTableBody();
        EOTFoot tFoot = tgroup.getTableFoot();
        List tRows = tBody.getRows();
        int columns = tgroup.getCols();
        int numberTableRows = numberBodyRows = tRows.size();
        if (tHead != null) {
            numberTableRows += tHead.getRows().size();
        }
        if (tFoot != null) {
            numberTableRows += tFoot.getRows().size();
        }
        if (numberTableRows > 0) {
            EORow row;
            Tables tables = range.get_Tables();
            Table table = tables.Add(range, numberTableRows, columns);
            if (logger.isDebugEnabled(150)) {
                logger.debug(150, "[write table] added table ");
            }
            table.set_RightPadding(1.0f);
            table.set_LeftPadding(1.0f);
            table.set_TopPadding(1.0f);
            table.set_BottomPadding(1.0f);
            Borders borders = table.get_Borders();
            if ("none".equals(eotable.getAttrFrame())) {
                borders.set_Enable(0);
            }
            borders.dispose();
            List colSpecs = tgroup.getColspec();
            Columns tableColumns = table.get_Columns();
            int tableColumnCount = tableColumns.get_Count();
            int i = 0;
            while (i < colSpecs.size() && i < tableColumnCount) {
                EOColSpec colSpec = (EOColSpec)colSpecs.get(i);
                Column column = tableColumns.Item(i + 1);
                Float widthInPoints = new Float(colSpec.getColumnwidthInPoints());
                column.set_Width(widthInPoints.floatValue());
                column.dispose();
                ++i;
            }
            tableColumns.dispose();
            if (logger.isDebugEnabled(150)) {
                logger.debug(150, "[write table] set table properties");
            }
            Rows rows = table.get_Rows();
            Row tableRow = rows.get_First();
            rows.dispose();
            if (logger.isDebugEnabled(150)) {
                logger.debug(150, "[write table] got first table row");
            }
            ArrayList<Row> headerRows = null;
            if (tHead != null) {
                List rowList = tHead.getRows();
                headerRows = new ArrayList<Row>(rowList.size());
                for (Object name : rowList) {
                    row = (EORow)name;
                    this.write(row, tableRow, colSpecs, document, styleMap, graphicsAndFilesStore, processingContext);
                    headerRows.add(tableRow);
                    tableRow = tableRow.get_Next();
                }
            }
            int i2 = 0;
            while (i2 < numberBodyRows) {
                EORow row2 = (EORow)tRows.get(i2);
                this.write(row2, tableRow, colSpecs, document, styleMap, graphicsAndFilesStore, processingContext);
                Row nextTableRow = tableRow.get_Next();
                tableRow.dispose();
                tableRow = nextTableRow;
                ++i2;
            }
            if (tFoot != null) {
                List rowList = tFoot.getRows();
                for (Object name : rowList) {
                    row = (EORow)name;
                    this.write(row, tableRow, colSpecs, document, styleMap, graphicsAndFilesStore, processingContext);
                    Row nextTableRow = tableRow.get_Next();
                    tableRow.dispose();
                    tableRow = nextTableRow;
                }
            }
            styleMap.applyTableStyle(table, eotable.getAttrTabstyle());
            if (headerRows == null || headerRows.isEmpty()) {
                table.set_ApplyStyleHeadingRows(false);
            } else if (headerRows.size() >= 2) {
                for (Row headerRow : headerRows) {
                    headerRow.set_HeadingFormat(-1);
                }
            }
            if (tFoot != null && !tFoot.getRows().isEmpty()) {
                table.set_ApplyStyleLastRow(true);
            }
            if (headerRows != null) {
                for (Row headerRow : headerRows) {
                    headerRow.dispose();
                }
            }
            table.dispose();
            tables.dispose();
        }
    }

    private void write(EORow eoRow, Row row, List<?> colspecs, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        List entries = eoRow.getEntryList();
        Cells rowCells = row.get_Cells();
        for (Object name : entries) {
            EOEntry entry = (EOEntry)name;
            String colnameStart = entry.getNamest();
            String colnameEnd = entry.getNameend();
            if (colnameStart != null && colnameEnd != null) {
                int colnameStartIndex = 0;
                int colnameEndIndex = 0;
                for (Object name2 : colspecs) {
                    EOColSpec colspec = (EOColSpec)name2;
                    String colname = colspec.getColname();
                    if (colname.equals(colnameStart)) {
                        colnameStartIndex = colspecs.indexOf(colspec) + 1;
                    }
                    if (!colname.equals(colnameEnd)) continue;
                    colnameEndIndex = colspecs.indexOf(colspec) + 1;
                }
                Cell startCell = rowCells.Item(colnameStartIndex);
                Cell endCell = rowCells.Item(colnameEndIndex);
                startCell.Merge(endCell);
                this.write(entry, startCell, document, styleMap, graphicsAndFilesStore, processingContext);
                startCell.dispose();
                endCell.dispose();
                continue;
            }
            int columnIndex = entries.indexOf(entry) + 1;
            Cell cell = rowCells.Item(columnIndex);
            this.write(entry, cell, document, styleMap, graphicsAndFilesStore, processingContext);
            cell.dispose();
        }
        rowCells.dispose();
        if (logger.isDebugEnabled(150)) {
            logger.debug(150, "[write table] wrote table row");
        }
    }

    private void write(EOEntry entry, Cell cell, Document document, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ProcessingContext processingContext) throws ReportGenerationException {
        boolean endsWithString;
        Range range = cell.get_Range();
        ReportJob reportJob = processingContext.getReportJob();
        boolean noEmptyLineAtEndOfWordTableCells = ReportTemplateHeaders.isHeaderParameterTrue((Map)reportJob.getReportTemplateHeader(), (String)TEMPLATE_HEADER_NO_EMPTY_LINE_AT_END_OF_WORD_TABLE_CELLS);
        boolean allowMarkups = EOCommonObject.allowMarkups((ReportJob)reportJob);
        range.set_End(range.get_End() - 1);
        styleMap.applyTableEntryStyle(range, entry.getRole());
        String vertAlign = entry.getValign();
        if (vertAlign != null) {
            if (vertAlign.equals("bottom")) {
                cell.set_VerticalAlignment(3);
            } else if (vertAlign.equals("middle")) {
                cell.set_VerticalAlignment(1);
            } else if (vertAlign.equals("top")) {
                cell.set_VerticalAlignment(0);
            }
        }
        Paragraphs paragraphs = range.get_Paragraphs();
        String horAlign = entry.getAlign();
        if (horAlign != null) {
            if (horAlign.equals("center")) {
                paragraphs.set_Alignment(1);
            } else if (horAlign.equals("justify")) {
                paragraphs.set_Alignment(3);
            } else if (horAlign.equals("left")) {
                paragraphs.set_Alignment(0);
            } else if (horAlign.equals("right")) {
                paragraphs.set_Alignment(2);
            }
        }
        if (entry.getRotate()) {
            range.set_Orientation(2);
        }
        int nrOfParagraphsLeft = 0;
        List content = entry.getContent(processingContext.getReportJob());
        for (Object obj : content) {
            if (!(obj instanceof EOPara) && !(obj instanceof EOTable)) continue;
            ++nrOfParagraphsLeft;
        }
        Paragraph lastParagraph = null;
        Enumeration elements = paragraphs.elements();
        while (elements.hasMoreElements()) {
            if (lastParagraph != null) {
                lastParagraph.dispose();
            }
            lastParagraph = (Paragraph)elements.nextElement();
        }
        List content2 = entry.getContent(processingContext.getReportJob());
        boolean bl = endsWithString = content2.size() > 0 && content2.get(content2.size() - 1) instanceof String;
        if (endsWithString && allowMarkups) {
            noEmptyLineAtEndOfWordTableCells = false;
        }
        for (Object obj : content2) {
            Paragraph paragraph;
            if (obj instanceof String) {
                if (allowMarkups) {
                    range.set_Start(range.get_End());
                }
                range.InsertBefore((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, range, processingContext);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, range, document, processingContext);
                continue;
            }
            if (obj instanceof EOUlink) {
                UlinkWriter.getInstance().write((EOUlink)obj, range, processingContext);
                continue;
            }
            if (obj instanceof EOEmphasis) {
                Range emphasisRange = EmphasisWriter.getInstance().write((EOEmphasis)obj, range, document, styleMap, processingContext);
                emphasisRange.dispose();
                continue;
            }
            if (obj instanceof EOPhrase) {
                PhraseWriter.getInstance().write((EOPhrase)obj, range, document, processingContext);
                continue;
            }
            if (obj instanceof EOPara) {
                paragraph = null;
                if (nrOfParagraphsLeft == 1 && noEmptyLineAtEndOfWordTableCells) {
                    paragraph = lastParagraph;
                }
                if (paragraph == null) {
                    paragraph = paragraphs.Add();
                }
                ParagraphWriter.getInstance().write((EOPara)obj, paragraph, document, styleMap, graphicsAndFilesStore, processingContext);
                paragraph.dispose();
                --nrOfParagraphsLeft;
                continue;
            }
            if (obj instanceof EOTable) {
                paragraph = null;
                if (nrOfParagraphsLeft == 1 && noEmptyLineAtEndOfWordTableCells) {
                    paragraph = lastParagraph;
                }
                if (paragraph == null) {
                    paragraph = paragraphs.Add();
                }
                this.write((EOTable)obj, paragraph, document, styleMap, graphicsAndFilesStore, processingContext);
                paragraph.dispose();
                --nrOfParagraphsLeft;
                continue;
            }
            if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, range, document, processingContext);
                continue;
            }
            if (!(obj instanceof EOMediaObject)) continue;
            MediaObjectWriter.getInstance().write((EOMediaObject)obj, range, graphicsAndFilesStore, processingContext);
        }
        paragraphs.dispose();
        range.dispose();
        if (logger.isDebugEnabled(150)) {
            logger.debug(150, "[write table] wrote table entry");
        }
    }
}

