/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.word.StyleMap;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TableWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.TitleWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.WriterUtil;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import java.util.List;

public class SectionWriter {
    private static SectionWriter writer;
    private static final Integer WdBuiltinStyle_wdStyleNormal;

    static {
        WdBuiltinStyle_wdStyleNormal = -1;
    }

    public static SectionWriter getInstance() {
        if (writer == null) {
            writer = new SectionWriter();
        }
        return writer;
    }

    private SectionWriter() {
    }

    public void write(EOSection section, Document document, Integer headingStyle, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, DocBookPostProcessingProgress progress, ProcessingContext processingContext) throws ReportGenerationException, ReportGenerationCanceledException {
        EOSubtitle subtitle;
        assert (headingStyle <= -2 && headingStyle >= -10) : "Invalid heading style";
        progress.incrementSectionProgress();
        Integer titleParaHeadingStyle = headingStyle;
        Integer subtitleAndContentHeadingStyle = headingStyle <= -2 && headingStyle > -10 ? Integer.valueOf(headingStyle - 1) : titleParaHeadingStyle;
        EOTitle title = section.getTitle();
        if (title != null) {
            Paragraph titlePara = WriterUtil.createNewParagraph(document, processingContext);
            titlePara.set_Style((Object)titleParaHeadingStyle);
            TitleWriter.getInstance().write(title, titlePara, document, processingContext);
            titlePara.dispose();
        }
        if ((subtitle = section.getSubtitle()) != null) {
            Paragraph subtitlePara = WriterUtil.createNewParagraph(document, processingContext);
            subtitlePara.set_Style((Object)subtitleAndContentHeadingStyle);
            SubTitleWriter.getInstance().write(subtitle, subtitlePara, document, processingContext);
            subtitlePara.dispose();
        }
        List contentList = section.getContent();
        for (Object obj : contentList) {
            Paragraph sectionPara;
            if (obj instanceof EOAnchor) {
                sectionPara = WriterUtil.createNewParagraph(document, processingContext);
                AnchorWriter.getInstance().write((EOAnchor)obj, sectionPara, processingContext);
                sectionPara.dispose();
            } else if (obj instanceof EOMediaObject) {
                sectionPara = WriterUtil.createNewParagraph(document, processingContext);
                MediaObjectWriter.getInstance().write((EOMediaObject)obj, sectionPara, graphicsAndFilesStore, processingContext);
                sectionPara.dispose();
            } else if (obj instanceof EOPara) {
                sectionPara = WriterUtil.createNewParagraph(document, processingContext);
                sectionPara.set_Style((Object)WdBuiltinStyle_wdStyleNormal);
                ParagraphWriter.getInstance().write((EOPara)obj, sectionPara, document, styleMap, graphicsAndFilesStore, processingContext);
                sectionPara.dispose();
            } else if (obj instanceof EOSection) {
                this.write((EOSection)obj, document, subtitleAndContentHeadingStyle, styleMap, graphicsAndFilesStore, progress, processingContext);
            } else if (obj instanceof EOTable) {
                sectionPara = WriterUtil.createNewParagraph(document, processingContext);
                sectionPara.set_Style((Object)WdBuiltinStyle_wdStyleNormal);
                TableWriter.getInstance().write((EOTable)obj, sectionPara, document, styleMap, graphicsAndFilesStore, processingContext);
                sectionPara.dispose();
            } else if (obj instanceof EOSimpleList) {
                sectionPara = WriterUtil.createNewParagraph(document, processingContext);
                sectionPara.set_Style((Object)WdBuiltinStyle_wdStyleNormal);
                SimpleListWriter.getInstance().write((EOSimpleList)obj, sectionPara, document, processingContext);
                sectionPara.dispose();
            }
            progress.checkCancelState();
        }
    }
}

