/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;

public class DocBook2WordMLGenerationContext {
    private final ReportJob reportJob;
    private int imageCounter;
    private int anchorCounter;
    private int chapterCounter;
    private final GraphicsAndFilesStore graphicsAndFilesStore;
    private final Set<String> alreadyEmbeddedImages;
    private Node mainSectionProperties;
    private Node coverSectionProperties;
    private int pageHeight;
    private int pageWidth;

    public DocBook2WordMLGenerationContext(GraphicsAndFilesStore graphicsAndFilesStore, ReportJob reportJob) {
        this.reportJob = reportJob;
        this.imageCounter = -1;
        this.anchorCounter = -1;
        this.chapterCounter = -1;
        this.graphicsAndFilesStore = graphicsAndFilesStore;
        this.alreadyEmbeddedImages = new HashSet<String>();
        this.mainSectionProperties = null;
        this.coverSectionProperties = null;
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    public GraphicsAndFilesStore getGraphicsAndFilesStore() {
        return this.graphicsAndFilesStore;
    }

    public boolean checkWhetherImageIsAlreadyEmbeddedAndAddItToListOfEmbeddedImagesIfNot(String fileName) {
        boolean isAlreadyEmbedded = this.alreadyEmbeddedImages.contains(fileName);
        if (!isAlreadyEmbedded) {
            this.alreadyEmbeddedImages.add(fileName);
        }
        return isAlreadyEmbedded;
    }

    public int getNextFreeImageIndex() {
        ++this.imageCounter;
        return this.imageCounter;
    }

    public int getNextFreeAnchorIndex() {
        ++this.anchorCounter;
        return this.anchorCounter;
    }

    public int getNextFreeChapterIndex() {
        ++this.chapterCounter;
        return this.chapterCounter;
    }

    public Node getMainSectionProperties() {
        return this.mainSectionProperties;
    }

    public void setMainSectionProperties(Node mainSectionProperties) {
        this.mainSectionProperties = mainSectionProperties;
    }

    public Node getCoverSectionProperties() {
        return this.coverSectionProperties;
    }

    public void setCoverSectionProperties(Node coverSectionProperties) {
        this.coverSectionProperties = coverSectionProperties;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }
}

