/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML;

import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.AbstractDocBookDocumentationWriter;
import com.arcway.cockpit.docgen.writer.docbook.model.DocBookEOFactory;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.wordML.ClientFunctionLicenseTypeReportsWordML;
import com.arcway.cockpit.docgen.writer.wordML.Messages;
import com.arcway.cockpit.docgen.writer.wordML.ModulePlugin;
import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocumentWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.WordMLReader;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;

public class WordMLDocumentationWriter
extends AbstractDocBookDocumentationWriter {
    private static final ILogger logger = Logger.getLogger(WordMLDocumentationWriter.class);
    public static final String FORMAT_ID = "WORDML_DOCUMENT";
    private static int IMAGE_RESOLUTION = 300;
    private static int PREFERRED_IMAGE_SIZE = 160;
    private static final String FILES_AND_IMAGES_DIRECTORY_NAME = "files_and_images";
    private static final Set<String> imageFileTypes = new HashSet<String>();

    public WordMLDocumentationWriter() {
        super(true, true);
        imageFileTypes.add("PNG");
        imageFileTypes.add("GIF");
        imageFileTypes.add("JPG");
        imageFileTypes.add("JPEG");
        imageFileTypes.add("BMP");
        imageFileTypes.add("WMF");
        imageFileTypes.add("EMF");
    }

    public String getID() {
        return FORMAT_ID;
    }

    public String getDisplayName() {
        return Messages.getString("WordDocumentationWriter.word");
    }

    public String getDescription() {
        return Messages.getString("WordDocumentationWriter.description");
    }

    public String getRequiredOutputTemplateTypeID() {
        return FORMAT_ID;
    }

    public String getOutputFormat(IReportTemplate reportTemplate) {
        return FORMAT_ID;
    }

    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInMM((Dimension)new Dimension((double)PREFERRED_IMAGE_SIZE, (double)PREFERRED_IMAGE_SIZE), (double)IMAGE_RESOLUTION);
    }

    public String getPreferredImageType() {
        IPreferenceStore store = ModulePlugin.getDefault().getPreferenceStore();
        String format = store.getString("wordMLPreferences.SELECTEDIMAGEFORMAT");
        if (format == null || format.length() == 0) {
            logger.debug("No image format preference for word ml available - default value used");
            format = ".emf";
        }
        return format;
    }

    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        try {
            if (imageFileTypes.contains(format.toUpperCase())) {
                return this.getDocBookSnippetForEmbeddedMediaObject(fileName, displayName, format, width_mm, height_mm, false);
            }
            return this.getDocBookSnippetForExternalFileLink("files_and_images/" + fileName, displayName);
        }
        catch (EXEncoderException e) {
            throw new RuntimeException("Unable to create DocBookSnippet for ExternalFileLink or ExternalFileLink.", e);
        }
    }

    protected void postProcessWithProgress(VelocityReportJob reportJob, IWorkbenchPage workbenchPage, IProgressMonitor progressMonitor) throws ReportGenerationCanceledException, ReportGenerationException {
        this.copyGraphicsAndFilesToTargetLocation(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME, new IFileValidator(){

            public boolean isValid(File file) {
                return WordMLDocumentationWriter.this.isOLEFile(file);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("createDocument() - externally linked files were copied into the files directory");
        }
        try {
            DocBookEOFactory factory = new DocBookEOFactory();
            EOBook docBook = factory.load(reportJob.getRawReportFile().getAbsolutePath());
            File outputTemplateFile = reportJob.getBaseReportJob().getOutputTemplateFile();
            File targetDirectory = new File(reportJob.getBaseReportJob().getReportFilename());
            File targetFile = new File(targetDirectory, String.valueOf(targetDirectory.getName()) + ".xml");
            this.copyAdditionalFileToTargetLocation(reportJob, outputTemplateFile, targetFile.getName());
            reportJob.getBaseReportJob().setReportMainFileName(targetFile.getAbsolutePath());
            WordMLReader wordMLFile = new WordMLReader(targetFile, reportJob.getBaseReportJob().getReportLocale());
            StyleMap styleMap = new StyleMap(wordMLFile);
            DocumentWriter.getInstance().write(docBook, wordMLFile, styleMap, reportJob.getGraphicsAndFilesStore(), reportJob.getBaseReportJob(), progressMonitor);
            if (logger.isDebugEnabled()) {
                logger.debug("createDocument() - document creation complete");
            }
            reportJob.getBaseReportJob().setUserInfoMessage(Messages.getString("UpdateFieldsAfterOpeningDocument.Title"), Messages.getString("UpdateFieldsAfterOpeningDocument.Message"), ModulePlugin.getDefault().getPreferenceStore(), "wordMLPreferences.showUpdateFieldsMessage");
        }
        catch (ReportGenerationCanceledException rgcE) {
            throw rgcE;
        }
        catch (ReportGenerationException rgE) {
            throw rgE;
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("WordMLDocumentationWriter.WordGenerationFailed_Title"), Messages.getString("WordMLDocumentationWriter.WordGenerationFailed_Message"), (Throwable)e);
        }
    }

    private boolean isOLEFile(File file) {
        String fileExtension = FileHelper.getFileExtension((File)file);
        return !imageFileTypes.contains(fileExtension.toUpperCase());
    }

    protected void postprocessingInterrupted(VelocityReportJob reportJob) {
        this.cleanUpReportFile(reportJob);
        this.cleanUpAdditionalDirectory(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
    }

    public IClientFunctionLicenseType getNeededLicenseType() {
        return ClientFunctionLicenseTypeReportsWordML.getInstance();
    }
}

