/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.transactions;

public class RepositoryMergeState {
    public static final RepositoryMergeState OK = new RepositoryMergeState("Ok");
    public static final RepositoryMergeState WARNING = new RepositoryMergeState("Warning");
    public static final RepositoryMergeState CONFLICT_WARNING = new RepositoryMergeState("Conflict Warning");
    public static final RepositoryMergeState LOCKSET_WARNING = new RepositoryMergeState("Lock Set Warning");
    public static final RepositoryMergeState ERROR = new RepositoryMergeState("Error");
    private final String name;

    private RepositoryMergeState(String str) {
        this.name = str;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWarning() {
        return this == WARNING || this == CONFLICT_WARNING || this == LOCKSET_WARNING;
    }

    public static RepositoryMergeState getMostSevere(RepositoryMergeState state1, RepositoryMergeState state2) {
        RepositoryMergeState result;
        if (state1 == state2) {
            return state1;
        }
        if (state1 == ERROR || state2 == ERROR) {
            result = ERROR;
        } else if (state1 == null) {
            result = state2;
        } else if (state2 == null) {
            result = state1;
        } else if (state1.isWarning() && state2 == OK) {
            result = state1;
        } else if (state1 == OK && state2.isWarning()) {
            result = state2;
        } else {
            assert (state1 == WARNING || state1 == CONFLICT_WARNING || state1 == LOCKSET_WARNING);
            assert (state2 == WARNING || state2 == CONFLICT_WARNING || state2 == LOCKSET_WARNING);
            result = WARNING;
        }
        return result;
    }
}

