/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.lock.RepositoryObjectLockType;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;

public abstract class AbstractRepositoryObjectLockSample
extends AbstractRepositoryLockSample {
    public abstract IRepositoryObjectTypeID getObjectTypeID();

    public abstract IRepositoryPropertySetSample getObjectID();

    public abstract RepositoryObjectLockType getLockType();

    @Override
    public boolean isEqualTo(AbstractRepositoryLockSample sample) {
        if (this == sample) {
            return true;
        }
        if (sample == null) {
            return false;
        }
        if (!(sample instanceof AbstractRepositoryObjectLockSample)) {
            return false;
        }
        AbstractRepositoryObjectLockSample other = (AbstractRepositoryObjectLockSample)sample;
        assert (this.getObjectID() != null && this.getObjectTypeID() != null && this.getLockType() != null);
        assert (other.getObjectID() != null && other.getObjectTypeID() != null && other.getLockType() != null);
        if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)this.getObjectTypeID(), (Object)other.getObjectTypeID()) && RepositorySamples.isEqual(this.getObjectID(), other.getObjectID()) && this.getLockType() == other.getLockType()) {
            if (this.getBasedSnapshotID() == null) {
                return other.getBasedSnapshotID() == null;
            }
            return RepositorySamples.isEqual(this.getBasedSnapshotID(), other.getBasedSnapshotID());
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RepositoryObjectLockSample: ");
        str.append("{lock type=");
        str.append(this.getLockType());
        str.append(", object type id=");
        str.append(this.getObjectTypeID());
        str.append(", object id=");
        str.append(this.getObjectID());
        str.append(", based snapshot id=");
        str.append(this.getBasedSnapshotID());
        str.append('}');
        return str.toString();
    }

    @Override
    public boolean isCurrent(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        IRepositoryObjectType objectType = snapshot.getRepositoryInterface().getTypeManager().getObjectType(this.getObjectTypeID());
        IRepositoryObject object = snapshot.findRepositoryObject(objectType, this.getObjectID());
        return RepositorySamples.isEqual(this.getBasedSnapshotID(), object.getSnapshotIDOfLastModification(this.getLockType()));
    }
}

