/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;

public class READeleteCrossLinkRelation
extends AbstractElementaryAction {
    private static final ILogger logger = Logger.getLogger(READeleteCrossLinkRelation.class);
    private ICrossLinkRepositoryRelationReference relationToDeleteReference;
    private ICrossLinkRepositoryRelationSample deletedRelation;

    public READeleteCrossLinkRelation(ICrossLinkRepositoryRelationReference relationToDelete) {
        this.relationToDeleteReference = relationToDelete;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (this.relationToDeleteReference != null);
        ICrossLinkRepositoryRelation relationToDelete = RepositoryReferences.getRelationFromReference((ICrossLinkRepositoryRelationReference)this.relationToDeleteReference, (IRepositorySnapshotRO)snapshot);
        assert (relationToDelete != null);
        snapshot.deleteRelation(relationToDelete);
        this.deletedRelation = relationToDelete.sample();
        try {
            this.setLocks(LockHelper.lockCrossLinkRelation(relationToDelete));
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("Error getting locks for delete relation", (Throwable)e);
            this.rollback(snapshot);
            throw e;
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (this.deletedRelation != null);
        snapshot.createRelation(this.deletedRelation);
        this.deletedRelation = null;
    }

    public String getName() {
        return "Delete Relation Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        READeleteCrossLinkRelation clone = (READeleteCrossLinkRelation)((Object)super.clone());
        clone.relationToDeleteReference = this.relationToDeleteReference;
        return clone;
    }
}

