/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IListIteratorRW_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.implementation.registration.type.module.RepositoryModuleType;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;

public class RTATMRegisterModuleType
implements IRegistrationAction {
    private final RepositoryTypeManager typeManager;
    private final RepositoryModuleType moduleType;

    public RTATMRegisterModuleType(RepositoryTypeManager typeManager, RepositoryModuleType moduleType) {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)moduleType);
        this.typeManager = typeManager;
        this.moduleType = moduleType;
    }

    @Override
    public void dodo() {
        IRepositoryModuleTypeID moduleTypeID = this.moduleType.getRepositoryModuleTypeID();
        IMapRW_<IRepositoryModuleTypeID, RepositoryModuleType> allModuleTypes = this.typeManager.allModuleTypes;
        IListRW_<RepositoryModuleType> listOfAllModuleTypes = this.typeManager.listOfAllModuleTypes;
        Assert.checkState((!allModuleTypes.containsKey((Object)moduleTypeID) ? 1 : 0) != 0);
        allModuleTypes.put((Object)moduleTypeID, (Object)this.moduleType);
        listOfAllModuleTypes.add((Object)this.moduleType);
    }

    @Override
    public void undo() {
        IRepositoryModuleTypeID moduleTypeID = this.moduleType.getRepositoryModuleTypeID();
        IMapRW_<IRepositoryModuleTypeID, RepositoryModuleType> allModuleTypes = this.typeManager.allModuleTypes;
        IListRW_<RepositoryModuleType> listOfAllModuleTypes = this.typeManager.listOfAllModuleTypes;
        Assert.checkState((boolean)allModuleTypes.containsKey((Object)moduleTypeID));
        RepositoryModuleType removedModuleType = (RepositoryModuleType)allModuleTypes.removeAsValue((Object)moduleTypeID);
        IListIteratorRW_ i = listOfAllModuleTypes.iterator();
        while (i.hasNext()) {
            RepositoryModuleType currentModuleType = (RepositoryModuleType)i.next();
            if (currentModuleType != removedModuleType) continue;
            i.remove();
        }
    }
}

