/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.repository.implementation.registration.transaction.RegistrationTransaction;
import com.arcway.repository.implementation.registration.type.EXCouldNotLoadAllDeclarations;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadAllDependentModuleTypes;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadDependentModuleType;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;

public class IterativeDeclarationLoader {
    public static void loadModuleTypeDeclarations(ICollection_<IRepositoryModuleTypeDeclaration> declarationsToLoad, ILoader loader) throws EXCouldNotLoadAllDependentModuleTypes {
        ArrayList_ remainingDeclarationsToLoad = new ArrayList_(declarationsToLoad);
        ArrayList_ loadExceptions = new ArrayList_(declarationsToLoad.size());
        boolean somethingWasLoaded = true;
        while (somethingWasLoaded) {
            loadExceptions.clear();
            somethingWasLoaded = false;
            IIteratorRW_ i = remainingDeclarationsToLoad.iterator();
            while (i.hasNext()) {
                IRepositoryModuleTypeDeclaration declaration = (IRepositoryModuleTypeDeclaration)i.next();
                IRepositoryModuleTypeID moduleTypeID = declaration.getModuleTypeID();
                if (moduleTypeID == null) {
                    moduleTypeID = IRepositoryModuleTypeID.UNNKOWN_MODULE_TYPE_ID;
                }
                RegistrationTransaction registrationTransaction = new RegistrationTransaction(moduleTypeID);
                try {
                    loader.loadDeclaration(registrationTransaction, declaration);
                    i.remove();
                    registrationTransaction.commit();
                    somethingWasLoaded = true;
                }
                catch (EXRepositoryDeclarationInvalid e) {
                    loadExceptions.add((Object)new EXCouldNotLoadDependentModuleType(moduleTypeID, e));
                    registrationTransaction.discard();
                }
                catch (RuntimeException e) {
                    registrationTransaction.discard();
                    throw e;
                }
            }
        }
        if (!loadExceptions.isEmpty()) {
            throw new EXCouldNotLoadAllDependentModuleTypes((ICollection_)loadExceptions);
        }
    }

    public static void loadDeclarations(final RegistrationTransaction registrationTransaction, ICollection_<? extends Object> declarationsToLoad, ILoader loader) throws EXCouldNotLoadAllDeclarations {
        IterativeDeclarationLoader.loadDeclarations(declarationsToLoad, new ITransactionProvider(){

            @Override
            public RegistrationTransaction getRegistrationTransactionForDeclaration(Object declaration) {
                return new RegistrationTransaction(registrationTransaction);
            }
        }, loader);
    }

    private static void loadDeclarations(ICollection_<? extends Object> declarationsToLoad, ITransactionProvider transactionProvider, ILoader loader) throws EXCouldNotLoadAllDeclarations {
        ArrayList_ remainingDeclarationsToLoad = new ArrayList_(declarationsToLoad);
        ArrayList_ loadExceptions = new ArrayList_(declarationsToLoad.size());
        boolean somethingWasLoaded = true;
        while (somethingWasLoaded) {
            loadExceptions.clear();
            somethingWasLoaded = false;
            IIteratorRW_ i = remainingDeclarationsToLoad.iterator();
            while (i.hasNext()) {
                Object declaration = i.next();
                RegistrationTransaction registrationTransaction = transactionProvider.getRegistrationTransactionForDeclaration(declaration);
                try {
                    loader.loadDeclaration(registrationTransaction, declaration);
                    i.remove();
                    registrationTransaction.commit();
                    somethingWasLoaded = true;
                }
                catch (EXRepositoryDeclarationInvalid e) {
                    loadExceptions.add((Object)e);
                    registrationTransaction.discard();
                }
                catch (RuntimeException e) {
                    registrationTransaction.discard();
                    throw e;
                }
            }
        }
        if (!loadExceptions.isEmpty()) {
            throw new EXCouldNotLoadAllDeclarations((ICollection_<EXRepositoryDeclarationInvalid>)loadExceptions, (ICollection_<? extends Object>)remainingDeclarationsToLoad);
        }
    }

    private IterativeDeclarationLoader() {
    }

    public static interface ILoader {
        public void loadDeclaration(RegistrationTransaction var1, Object var2) throws EXRepositoryDeclarationInvalid;
    }

    private static interface ITransactionProvider {
        public RegistrationTransaction getRegistrationTransactionForDeclaration(Object var1);
    }
}

