/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.implementation;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadModule;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadModuleManager;
import com.arcway.repository.interFace.chassis.exceptions.EXSetupFailed;
import com.arcway.repository.interFace.chassis.exceptions.EXUnexpectedClass;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownDeclarationItem;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownImplementationType;
import com.arcway.repository.interFace.data.manager.IRepositoryModuleManager;
import com.arcway.repository.interFace.data.manager.IRepositoryModuleManagerFactory;
import com.arcway.repository.interFace.data.manager.IRepositoryModuleManagerFactoryParameter;
import com.arcway.repository.interFace.data.manager.IRepositoryModuleManagerFactoryRegistration;
import com.arcway.repository.interFace.data.module.IRepositoryModule;
import com.arcway.repository.interFace.data.module.IRepositoryModuleFactory;
import com.arcway.repository.interFace.data.module.IRepositoryModuleFactoryParameter;
import com.arcway.repository.interFace.data.module.IRepositoryModuleFactoryRegistration;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.implementation.AbstractRepositoryImplementationDescription;
import com.arcway.repository.interFace.implementation.IRepositoryImplementationManager;
import com.arcway.repository.interFace.implementation.IRepositoryImplementationTypeID;
import com.arcway.repository.interFace.implementation.IRepositoryImplementationTypeRegistration;
import com.arcway.repository.interFace.plugin.extensions.IRepositoryImplementationRegistryReader;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;

public class RepositoryImplementationManager
implements IRepositoryImplementationManager,
IRepositoryImplementationRegistryReader {
    private final IRepositoryModuleManager moduleManager;
    private final IListRW_<IRepositoryModule> setupModulesInOrderOfSetup = new ArrayList_();
    private final IMapRW_<IRepositoryModuleType, IRepositoryModule> setupModulesByModuleType = new HashMap_(IHasher_.EQUALS_HASHER);

    public RepositoryImplementationManager(IRepositoryTypeManagerRO typeManager, AbstractRepositoryImplementationDescription implementationDescription) throws EXUnknownImplementationType, EXCouldNotLoadModuleManager, EXCouldNotLoadModule {
        IRepositoryModuleFactoryParameter moduleFactoryParameter;
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)implementationDescription);
        IRepositoryImplementationTypeID implementationTypeID = implementationDescription.getImplementationTypeID();
        IRepositoryModuleManagerFactoryParameter moduleManagerFactoryParameter = implementationDescription.getModuleManagerFactoryParameter();
        Assert.checkArgumentBeeingNotNull((Object)implementationTypeID);
        Assert.checkArgumentBeeingNotNull((Object)moduleManagerFactoryParameter);
        IRepositoryImplementationTypeRegistration implementationTypeRegistration = this.getReferencedImplementationTypeRegistration(implementationTypeID);
        Class expectedModuleManagerFactoryParameterClass = implementationTypeRegistration.getModuleManagerFactoryParameterClass();
        Class expectedModuleManagerClass = implementationTypeRegistration.getModuleManagerClass();
        Class expectedModuleFactoryParameterClass = implementationTypeRegistration.getModuleFactoryParameterClass();
        Class expectedModuleClass = implementationTypeRegistration.getModuleClass();
        if (!expectedModuleManagerFactoryParameterClass.isInstance(moduleManagerFactoryParameter)) {
            throw new EXCouldNotLoadModuleManager(implementationTypeID, (Throwable)new EXUnexpectedClass(moduleManagerFactoryParameter.getClass(), expectedModuleManagerFactoryParameterClass));
        }
        IRepositoryModuleManagerFactoryRegistration moduleManagerFactoryRegistration = this.getReferencedModuleManagerFactoryRegistration(implementationTypeID);
        IRepositoryModuleManagerFactory moduleManagerFactory = moduleManagerFactoryRegistration.getModuleManagerFactory();
        this.moduleManager = moduleManagerFactory.createModuleManager(typeManager, moduleManagerFactoryParameter);
        if (this.moduleManager == null) {
            throw new EXCouldNotLoadModuleManager(implementationTypeID, (Throwable)new NullPointerException());
        }
        if (!expectedModuleManagerClass.isInstance(this.moduleManager)) {
            throw new EXCouldNotLoadModuleManager(implementationTypeID, (Throwable)new EXUnexpectedClass(this.moduleManager.getClass(), expectedModuleManagerClass));
        }
        try {
            moduleFactoryParameter = this.moduleManager.beginSetup();
        }
        catch (EXSetupFailed setupException) {
            this.moduleManager.setupFailedBeginShutdown();
            this.moduleManager.setupFailedEndShutdown();
            throw new EXCouldNotLoadModuleManager(implementationTypeID, setupException.getCause());
        }
        if (moduleFactoryParameter == null) {
            throw new EXCouldNotLoadModuleManager(implementationTypeID, (Throwable)new NullPointerException());
        }
        if (!expectedModuleFactoryParameterClass.isInstance(moduleFactoryParameter)) {
            this.moduleManager.setupFailedBeginShutdown();
            this.moduleManager.setupFailedEndShutdown();
            throw new EXCouldNotLoadModuleManager(implementationTypeID, (Throwable)new EXUnexpectedClass(moduleFactoryParameter.getClass(), expectedModuleFactoryParameterClass));
        }
        IRepositoryModuleTypeID currentModuleTypeID = null;
        try {
            IList_ moduleTypes = typeManager.getAllModuleTypes();
            for (IRepositoryModuleType currentModuleType : moduleTypes) {
                currentModuleTypeID = currentModuleType.getRepositoryModuleTypeID();
                IRepositoryModuleFactoryRegistration moduleFactoryRegistration = this.getReferencedModuleFactoryRegistration(implementationTypeID, currentModuleTypeID);
                IRepositoryModuleFactory moduleFactory = moduleFactoryRegistration.getModuleFactory();
                IRepositoryModule module = moduleFactory.createModule(currentModuleType, moduleFactoryParameter);
                if (module == null) {
                    throw new EXSetupFailed((Throwable)new EXCouldNotLoadModule(implementationTypeID, currentModuleTypeID, (Throwable)new NullPointerException()));
                }
                if (!expectedModuleClass.isInstance(module)) {
                    throw new EXSetupFailed((Throwable)new EXCouldNotLoadModule(implementationTypeID, currentModuleTypeID, (Throwable)new EXUnexpectedClass(module.getClass(), expectedModuleClass)));
                }
                this.setupModulesInOrderOfSetup.add((Object)module);
                this.setupModulesByModuleType.put((Object)currentModuleType, (Object)module);
            }
            this.moduleManager.endSetup(this.setupModulesInOrderOfSetup, this.setupModulesByModuleType);
        }
        catch (EXSetupFailed e) {
            this.moduleManager.setupFailedBeginShutdown();
            this.shutDownAllModules();
            this.moduleManager.setupFailedEndShutdown();
            Throwable cause = e.getCause();
            if (cause instanceof EXCouldNotLoadModule) {
                EXCouldNotLoadModule couldNotLoadModule = (EXCouldNotLoadModule)cause;
                throw couldNotLoadModule;
            }
            throw new EXCouldNotLoadModule(implementationTypeID, currentModuleTypeID, cause);
        }
    }

    public IRepositoryModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public IRepositoryModule getModule(IRepositoryModuleType moduleType) {
        IRepositoryModule module = (IRepositoryModule)this.setupModulesByModuleType.getByKey((Object)moduleType);
        Assert.checkState((module != null ? 1 : 0) != 0, (String)("unknown module type " + moduleType));
        return module;
    }

    public void shutdown() {
        this.moduleManager.beginShutdown();
        this.shutDownAllModules();
        this.moduleManager.endShutdown();
    }

    private void shutDownAllModules() {
        int i = this.setupModulesInOrderOfSetup.size() - 1;
        while (i >= 0) {
            IRepositoryModule currentModule = (IRepositoryModule)this.setupModulesInOrderOfSetup.get(i);
            IRepositoryModuleType currentModuleType = currentModule.getModuleType();
            currentModule.shutdown();
            this.setupModulesInOrderOfSetup.remove(i);
            this.setupModulesByModuleType.removeAsEntry((Object)currentModuleType);
            --i;
        }
    }

    private IRepositoryImplementationTypeRegistration getReferencedImplementationTypeRegistration(IRepositoryImplementationTypeID implementationTypeID) throws EXUnknownImplementationType {
        IRepositoryImplementationTypeRegistration registration = this.findImplementationTypeRegistration(implementationTypeID);
        if (registration == null) {
            throw new EXUnknownImplementationType(implementationTypeID);
        }
        return registration;
    }

    private IRepositoryImplementationTypeRegistration findImplementationTypeRegistration(IRepositoryImplementationTypeID implementationTypeID) {
        IRepositoryImplementationTypeRegistration foundRegistration = null;
        IIterator_ i = REPOSITORY_IMPLEMENTATION_TYPE_DECLARATIONS.iterator();
        while (foundRegistration == null && i.hasNext()) {
            IRepositoryImplementationTypeRegistration currentRegistration = (IRepositoryImplementationTypeRegistration)i.next();
            if (!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)currentRegistration.getRepositoryImplementationTypeID(), (Object)implementationTypeID)) continue;
            foundRegistration = currentRegistration;
        }
        return foundRegistration;
    }

    private IRepositoryModuleManagerFactoryRegistration getReferencedModuleManagerFactoryRegistration(IRepositoryImplementationTypeID implementationTypeID) throws EXCouldNotLoadModuleManager {
        IRepositoryModuleManagerFactoryRegistration registration = this.findModuleManagerFactoryRegistration(implementationTypeID);
        if (registration == null) {
            throw new EXCouldNotLoadModuleManager(implementationTypeID, (Throwable)new EXUnknownImplementationType(implementationTypeID));
        }
        return registration;
    }

    private IRepositoryModuleManagerFactoryRegistration findModuleManagerFactoryRegistration(IRepositoryImplementationTypeID implementationTypeID) {
        IRepositoryModuleManagerFactoryRegistration foundRegistration = null;
        IIterator_ i = REPOSITORY_MODULE_MANAGER_FACTORY_REGISTRATIONS.iterator();
        while (foundRegistration == null && i.hasNext()) {
            IRepositoryModuleManagerFactoryRegistration currentRegistration = (IRepositoryModuleManagerFactoryRegistration)i.next();
            if (!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)currentRegistration.getRepositoryImplementationTypeID(), (Object)implementationTypeID)) continue;
            foundRegistration = currentRegistration;
        }
        return foundRegistration;
    }

    private IRepositoryModuleFactoryRegistration getReferencedModuleFactoryRegistration(IRepositoryImplementationTypeID implementationTypeID, IRepositoryModuleTypeID moduleTypeID) throws EXCouldNotLoadModule {
        IRepositoryModuleFactoryRegistration registration = this.findModuleFactoryRegistration(implementationTypeID, moduleTypeID);
        if (registration == null) {
            throw new EXCouldNotLoadModule(implementationTypeID, moduleTypeID, (Throwable)new EXUnknownDeclarationItem((IRepositoryDeclarationItemID)moduleTypeID));
        }
        return registration;
    }

    private IRepositoryModuleFactoryRegistration findModuleFactoryRegistration(IRepositoryImplementationTypeID implementationTypeID, IRepositoryModuleTypeID moduleTypeID) {
        IRepositoryModuleFactoryRegistration foundRegistration = null;
        IIterator_ i = REPOSITORY_MODULE_FACTORY_REGISTRATIONS.iterator();
        while (foundRegistration == null && i.hasNext()) {
            IRepositoryModuleFactoryRegistration currentRegistration = (IRepositoryModuleFactoryRegistration)i.next();
            if (!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)currentRegistration.getRepositoryImplementationTypeID(), (Object)implementationTypeID) || !IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)currentRegistration.getRepositoryModuleTypeID(), (Object)moduleTypeID)) continue;
            foundRegistration = currentRegistration;
        }
        return foundRegistration;
    }
}

