/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.gui.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.gui.appearance.GUILineAndFillSupplementAppearance;
import com.arcway.planagent.planmodel.gui.appearance.IGUIAppearanceWithLineAndFillAppearanceRO;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementGUIWindowGraphic
extends PVGraphicalSupplement {
    private GUILineAndFillSupplementAppearance symbolAppearance = new GUILineAndFillSupplementAppearance();
    private static final double TITLE_HEIGHT = 7.5;

    public void setSymbolAppearance(GUILineAndFillSupplementAppearance appearance) {
        this.symbolAppearance = new GUILineAndFillSupplementAppearance((IGUIAppearanceWithLineAndFillAppearanceRO)appearance);
    }

    public void drawFigure(Device device) {
        assert (this.symbolAppearance != null) : "symbolAppearance is NULL";
        IFillAppearanceRO fillAppearance = this.symbolAppearance.getFillAppearanceRO();
        assert (fillAppearance != null) : "fillAppearance is null.";
        ILineAppearanceRO lineAppearance = this.symbolAppearance.getLineAppearanceRO();
        assert (lineAppearance != null) : "lineAppearance is null.";
        Color lineColor = lineAppearance.getLineColor();
        double thickness = lineAppearance.getLineThickness();
        LineStyle lineStyle = lineAppearance.getLineStyle();
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point upperLeft = bounds.upperLeft;
        Point lowerRight = bounds.lowerRight;
        if (bounds.h() > 7.5) {
            Corners corners = new Corners();
            corners.add((Point)new Corner(upperLeft.x, upperLeft.y + 7.5, 0.0));
            corners.add((Point)new Corner(lowerRight.x, upperLeft.y + 7.5, 0.0));
            device.polyline(corners, thickness, lineColor, lineStyle);
            Rectangle buttonBounds = new Rectangle(lowerRight.x - 7.5, upperLeft.y, lowerRight.x, upperLeft.y + 7.5);
            if (buttonBounds.upperLeft.x > upperLeft.x) {
                PVGraphicalSupplementGUIWindowGraphic.drawCloseButton(buttonBounds, device, thickness, lineColor, lineStyle);
                buttonBounds = buttonBounds.move(new GeoVector(-7.5, 0.0));
            }
            if (buttonBounds.upperLeft.x > upperLeft.x) {
                PVGraphicalSupplementGUIWindowGraphic.drawMaxButton(buttonBounds, device, thickness, lineColor, lineStyle);
                buttonBounds = buttonBounds.move(new GeoVector(-7.5, 0.0));
            }
            if (buttonBounds.upperLeft.x > upperLeft.x) {
                PVGraphicalSupplementGUIWindowGraphic.drawMinButton(buttonBounds, device, thickness, lineColor, lineStyle);
            }
        }
    }

    private static void drawCloseButton(Rectangle bounds, Device device, double thickness, Color lineColor, LineStyle lineStyle) {
        double BORDER = 0.2;
        double width = bounds.w();
        double height = bounds.h();
        Corners corners = new Corners();
        corners.add((Point)new Corner(bounds.upperLeft.x, bounds.upperLeft.y, 0.0));
        corners.add((Point)new Corner(bounds.upperLeft.x, bounds.lowerRight.y, 0.0));
        device.polyline(corners, thickness, lineColor, lineStyle);
        corners = new Corners();
        corners.add((Point)new Corner(bounds.upperLeft.x + width * 0.2, bounds.upperLeft.y + height * 0.2, 0.0));
        corners.add((Point)new Corner(bounds.lowerRight.x - width * 0.2, bounds.lowerRight.y - height * 0.2, 0.0));
        device.polyline(corners, thickness, lineColor, lineStyle);
        corners = new Corners();
        corners.add((Point)new Corner(bounds.lowerRight.x - width * 0.2, bounds.upperLeft.y + height * 0.2, 0.0));
        corners.add((Point)new Corner(bounds.upperLeft.x + width * 0.2, bounds.lowerRight.y - height * 0.2, 0.0));
        device.polyline(corners, thickness, lineColor, lineStyle);
    }

    private static void drawMaxButton(Rectangle bounds, Device device, double thickness, Color lineColor, LineStyle lineStyle) {
        double BORDER = 0.2;
        double width = bounds.w();
        double height = bounds.h();
        Corners corners = new Corners();
        corners.add((Point)new Corner(bounds.upperLeft.x, bounds.upperLeft.y, 0.0));
        corners.add((Point)new Corner(bounds.upperLeft.x, bounds.lowerRight.y, 0.0));
        device.polyline(corners, thickness, lineColor, lineStyle);
        corners = new Corners();
        corners.add((Point)new Corner(bounds.upperLeft.x + width * 0.2, bounds.upperLeft.y + height * 1.2 * 0.2, 0.0));
        corners.add((Point)new Corner(bounds.lowerRight.x - width * 0.2, bounds.upperLeft.y + height * 1.2 * 0.2, 0.0));
        corners.add((Point)new Corner(bounds.lowerRight.x - width * 0.2, bounds.lowerRight.y - height * 1.2 * 0.2, 0.0));
        corners.add((Point)new Corner(bounds.upperLeft.x + width * 0.2, bounds.lowerRight.y - height * 1.2 * 0.2, 0.0));
        device.polygon(corners, thickness, lineColor, lineStyle);
    }

    private static void drawMinButton(Rectangle bounds, Device device, double thickness, Color lineColor, LineStyle lineStyle) {
        double BORDER = 0.2;
        double width = bounds.w();
        double height = bounds.h();
        Corners corners = new Corners();
        corners.add((Point)new Corner(bounds.upperLeft.x, bounds.upperLeft.y, 0.0));
        corners.add((Point)new Corner(bounds.upperLeft.x, bounds.lowerRight.y, 0.0));
        device.polyline(corners, thickness, lineColor, lineStyle);
        corners = new Corners();
        corners.add((Point)new Corner(bounds.lowerRight.x - width * 0.2, bounds.lowerRight.y - height * 0.2, 0.0));
        corners.add((Point)new Corner(bounds.upperLeft.x + width * 0.2, bounds.lowerRight.y - height * 0.2, 0.0));
        device.polygon(corners, thickness, lineColor, lineStyle);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }
}

