/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.cm.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IStickmanAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IStickmanAppearanceRO;
import com.arcway.planagent.planmodel.cm.appearance.StickmanAppearance;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementStickman
extends PVGraphicalSupplement {
    private StickmanAppearance stickmanAppearance;

    public void setStickmanAppearance(IStickmanAppearance stickmanAppearance) {
        this.stickmanAppearance = new StickmanAppearance((IStickmanAppearanceRO)stickmanAppearance);
    }

    public void drawFigure(Device device) {
        assert (this.stickmanAppearance != null) : "stickmanAppearance is NULL";
        double size = this.stickmanAppearance.getSize() / 3.0;
        ILineAppearance lineAppearance = this.stickmanAppearance.getLineAppearance();
        assert (lineAppearance != null) : "lineAppearance is NULL.";
        LineStyle lineStyle = lineAppearance.getLineStyle();
        assert (lineStyle != null) : "lineStyle is NULL.";
        double lineThickness = lineAppearance.getLineThickness();
        Color lineColor = lineAppearance.getLineColor();
        assert (lineColor != null) : "lineColor is NULL.";
        assert (this.getPoints() != null) : "getPoints is NULL.";
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point centerPoint = bounds.center();
        assert (centerPoint != null) : "centerPoint is NULL.";
        this.drawGhostOutline(device);
        Corner c1 = new Corner(centerPoint.x, centerPoint.y, 0.0);
        Corner c2 = new Corner(c1.x + 1.75 * size, c1.y - 0.875 * size, 0.0);
        Corner c3 = new Corner(c1.x - 1.75 * size, c1.y - 0.875 * size, 0.0);
        Corner c4 = new Corner(c1.x, c1.y + 1.125 * size, 0.0);
        Corner c5 = new Corner(c4.x - 1.5 * size, c4.y + 1.75 * size, 0.0);
        Corner c6 = new Corner(c4.x + 1.5 * size, c4.y + 1.75 * size, 0.0);
        Corner c7 = new Corner(c1.x, c1.y - 0.875 * size, 0.0);
        Corner c8 = new Corner(c7.x - size, c7.y);
        Corner c9 = new Corner(c8.x, c8.y - 2.0 * size);
        Corner c10 = new Corner(c9.x + 2.0 * size, c9.y);
        Corner c11 = new Corner(c10.x, c10.y + 2.0 * size);
        Corners body = new Corners(2);
        body.add((Point)c7);
        body.add((Point)c4);
        Corners arms = new Corners(3);
        arms.add((Point)c2);
        arms.add((Point)c1);
        arms.add((Point)c3);
        Corners legs = new Corners(3);
        legs.add((Point)c5);
        legs.add((Point)c4);
        legs.add((Point)c6);
        Corners head = new Corners(4);
        head.add((Point)c8);
        head.add((Point)c9);
        head.add((Point)c10);
        head.add((Point)c11);
        device.polyline(body, lineThickness, lineColor, lineStyle);
        device.polyline(arms, lineThickness, lineColor, lineStyle);
        device.polyline(legs, lineThickness, lineColor, lineStyle);
        device.polygon(head, lineThickness, lineColor, lineStyle);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }
}

