/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.bpmn.bpd.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IFillAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMGraphicalSupplementBPMNBPDActivityMarkingSymbolsBarRO;
import com.arcway.planagent.planmodel.bpmn.bpd.appearance.BPMNBPDActivityMarkingSymbolsBarAppearance;
import com.arcway.planagent.planmodel.bpmn.bpd.appearance.IBPMNBPDActivityMarkingSymbolsBarAppearance;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;
import java.util.EnumSet;

public class PVGraphicalSupplementActivityMarkingSymbolsBar
extends PVGraphicalSupplement {
    private final double SYMBOL_SIZE = 4.0;
    private final double SYMBOL_INTERSPACE = 1.0;
    private final double BORDER_DISTANCE = 1.0;
    private final EnumSet<IPMGraphicalSupplementBPMNBPDActivityMarkingSymbolsBarRO.ActivityMarkingSymbolType> symbolsToDraw;
    private BPMNBPDActivityMarkingSymbolsBarAppearance symbolAppearance;

    public PVGraphicalSupplementActivityMarkingSymbolsBar(EnumSet<IPMGraphicalSupplementBPMNBPDActivityMarkingSymbolsBarRO.ActivityMarkingSymbolType> symbolsToDraw) {
        this.symbolsToDraw = symbolsToDraw;
    }

    public void setSymbolAppearance(IBPMNBPDActivityMarkingSymbolsBarAppearance symbolAppearance) {
        this.symbolAppearance = new BPMNBPDActivityMarkingSymbolsBarAppearance(symbolAppearance);
    }

    public void drawFigure(Device device) {
        assert (this.symbolAppearance != null) : "BPMNBPDActivityMarkingSymbolsBarAppearance is NULL";
        IFillAppearance fillAppearance = (IFillAppearance)this.symbolAppearance.getFillAppearanceRO();
        assert (fillAppearance != null) : "fillAppearance is null.";
        FillStyle fillStyle = fillAppearance.getFillStyle();
        FillColor fillColor = fillAppearance.getFillColor();
        ILineAppearance lineAppearance = (ILineAppearance)this.symbolAppearance.getLineAppearanceRO();
        assert (lineAppearance != null) : "lineAppearance is null.";
        Color color = lineAppearance.getLineColor();
        double thickness = 0.3;
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point center = bounds.center();
        double leftBound = center.x - 2.0 * (double)this.symbolsToDraw.size() - 0.5 * (double)(this.symbolsToDraw.size() - 1);
        double upperBound = bounds.lowerRight.y - 1.0 - 4.0;
        for (IPMGraphicalSupplementBPMNBPDActivityMarkingSymbolsBarRO.ActivityMarkingSymbolType singleSymbol : this.symbolsToDraw) {
            switch (singleSymbol) {
                case AdHoc: {
                    this.createAdHocSymbol(device, leftBound, upperBound, fillStyle, color, thickness);
                    break;
                }
                case Compensation: {
                    this.createcCompensation(device, leftBound, upperBound, fillColor, fillStyle, color, thickness);
                    break;
                }
                case Loop: {
                    this.createLoopSymbol(device, leftBound, upperBound, color, thickness);
                    break;
                }
                case Parallel: {
                    this.createParallelSymbol(device, leftBound, upperBound, fillStyle, color, thickness);
                    break;
                }
                case Sequential: {
                    this.createSequentialSymbol(device, leftBound, upperBound, fillStyle, color, thickness);
                    break;
                }
                case SubProcess: {
                    this.createSubProcessSymbol(device, leftBound, upperBound, fillColor, fillStyle, color, thickness);
                }
            }
            leftBound += 5.0;
        }
    }

    private void createAdHocSymbol(Device device, double leftBound, double upperBound, FillStyle fillStyle, Color lineColor, double thickness) {
        Corners corners = new Corners();
        corners.add((Point)new Corner(leftBound + 0.4, upperBound + 1.6, 0.0));
        corners.add((Point)new Corner(leftBound + 1.2, upperBound + 1.2));
        corners.add((Point)new Corner(leftBound + 2.8, upperBound + 2.0));
        corners.add((Point)new Corner(leftBound + 3.6, upperBound + 1.6, 0.0));
        corners.add((Point)new Corner(leftBound + 3.6, upperBound + 2.4, 0.0));
        corners.add((Point)new Corner(leftBound + 2.8, upperBound + 2.8));
        corners.add((Point)new Corner(leftBound + 1.2, upperBound + 2.0));
        corners.add((Point)new Corner(leftBound + 0.4, upperBound + 2.4, 0.0));
        device.polygon(corners, FillColor.BLACK, fillStyle, thickness, lineColor, LineStyle.SOLID);
    }

    private void createLoopSymbol(Device device, double leftBound, double upperBound, Color lineColor, double thickness) {
        Corners corners = new Corners();
        Corner circleStart = new Corner(leftBound + 2.0, upperBound + 4.0);
        Point circleCenter = new Point(leftBound + 2.0, upperBound + 2.0);
        corners.add((Point)circleStart);
        Corner circleEnd = null;
        int i = 1;
        while (i < 11) {
            circleEnd = circleStart.turnCorner(circleCenter, (double)(i * 35));
            corners.add((Point)circleEnd);
            ++i;
        }
        device.polyline(corners, thickness, lineColor, LineStyle.SOLID, LineMarker.NONE, LineMarker.PEAKED_ARC, 0.6);
    }

    private void createSubProcessSymbol(Device device, double leftBound, double upperBound, FillColor fillColor, FillStyle fillStyle, Color lineColor, double thickness) {
        Corners corners = new Corners();
        corners.add((Point)new Corner(leftBound, upperBound, 0.0));
        corners.add((Point)new Corner(leftBound, upperBound + 4.0, 0.0));
        corners.add((Point)new Corner(leftBound + 4.0, upperBound + 4.0, 0.0));
        corners.add((Point)new Corner(leftBound + 4.0, upperBound, 0.0));
        device.polygon(corners, fillColor, fillStyle, thickness, lineColor, LineStyle.SOLID);
        corners = new Corners();
        corners.add((Point)new Corner(leftBound + 0.6, upperBound + 2.0, 0.0));
        corners.add((Point)new Corner(leftBound + 3.4, upperBound + 2.0, 0.0));
        device.polyline(corners, thickness, lineColor, LineStyle.SOLID);
        corners = new Corners();
        corners.add((Point)new Corner(leftBound + 2.0, upperBound + 0.6, 0.0));
        corners.add((Point)new Corner(leftBound + 2.0, upperBound + 3.4, 0.0));
        device.polyline(corners, thickness, lineColor, LineStyle.SOLID);
    }

    private void createParallelSymbol(Device device, double leftBound, double upperBound, FillStyle fillStyle, Color lineColor, double thickness) {
        double rectangleWidth = 0.8;
        int i = 0;
        while (i < 5) {
            Corners corners = new Corners();
            corners.add((Point)new Corner(leftBound + rectangleWidth * (double)i, upperBound, 0.0));
            corners.add((Point)new Corner(leftBound + rectangleWidth * (double)i, upperBound + 4.0, 0.0));
            corners.add((Point)new Corner(leftBound + rectangleWidth * (double)(i + 1), upperBound + 4.0, 0.0));
            corners.add((Point)new Corner(leftBound + rectangleWidth * (double)(i + 1), upperBound, 0.0));
            device.polygon(corners, FillColor.BLACK, fillStyle, thickness, lineColor, LineStyle.SOLID);
            i += 2;
        }
    }

    private void createSequentialSymbol(Device device, double leftBound, double upperBound, FillStyle fillStyle, Color lineColor, double thickness) {
        double rectangleWidth = 0.8;
        int i = 0;
        while (i < 5) {
            Corners corners = new Corners();
            corners.add((Point)new Corner(leftBound, upperBound + rectangleWidth * (double)i, 0.0));
            corners.add((Point)new Corner(leftBound + 4.0, upperBound + rectangleWidth * (double)i, 0.0));
            corners.add((Point)new Corner(leftBound + 4.0, upperBound + rectangleWidth * (double)(i + 1), 0.0));
            corners.add((Point)new Corner(leftBound, upperBound + rectangleWidth * (double)(i + 1), 0.0));
            device.polygon(corners, FillColor.BLACK, fillStyle, thickness, lineColor, LineStyle.SOLID);
            i += 2;
        }
    }

    private void createcCompensation(Device device, double leftBound, double upperBound, FillColor fillColor, FillStyle fillStyle, Color lineColor, double thickness) {
        Corner singleCorner = new Corner(leftBound, upperBound + 2.0, 0.0);
        Point rotationCenter = new Point(leftBound + 1.28, upperBound + 2.0);
        Corners corners = new Corners();
        corners.add((Point)singleCorner);
        corners.add((Point)singleCorner.turnCorner(rotationCenter, 120.0));
        corners.add((Point)singleCorner.turnCorner(rotationCenter, 240.0));
        device.polygon(corners, fillColor, fillStyle, thickness, lineColor, LineStyle.SOLID);
        device.polygon(corners.moveCorners(new GeoVector(2.0, 0.0)), fillColor, fillStyle, thickness, lineColor, LineStyle.SOLID);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }
}

