/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import com.arcway.planagent.planmodel.transactions.EXActionNotValidException;
import com.arcway.planagent.planmodel.transactions.Transaction;
import com.arcway.planagent.planmodel.transactions.TransactionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TransactionProcessor {
    private static final ILogger logger = Logger.getLogger(Transaction.class);
    private static TransactionProcessor singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionProcessor getInstance() {
        Class<TransactionProcessor> clazz = TransactionProcessor.class;
        synchronized (TransactionProcessor.class) {
            if (singleton == null) {
                singleton = new TransactionProcessor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private TransactionProcessor() {
    }

    public void processTransaction(ActionIterator actions, TransactionContext transactionContext) throws EXActionNotValidException {
        assert (actions != null) : "actions is null";
        assert (transactionContext != null) : "transactionContext is null";
        this.processTransactionWithOptionalDupeCheck(actions, null, 0, transactionContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTransactionPostprocessing(TransactionContext transactionContext) {
        TransactionContext transactionContext2 = transactionContext;
        synchronized (transactionContext2) {
            int numberOfActions = transactionContext.getActionLogSize();
            PredeterminedActionIterator actionsToReact = new PredeterminedActionIterator(numberOfActions);
            int i = 0;
            while (i < numberOfActions) {
                actionsToReact.addAction(transactionContext.getActionLogEntry(i));
                ++i;
            }
            this.processReActions(actionsToReact, 1, transactionContext, ActionContext.ProcessingScope.POSTPROCESSORS);
        }
    }

    private void processTransactionWithOptionalDupeCheck(ActionIterator actions, Action cause, int depth, TransactionContext transactionContext, boolean startDupeCheck) throws EXActionNotValidException {
        assert (actions != null) : "actions is null";
        assert (transactionContext != null) : "transactionContext is null";
        PredeterminedActionIterator actionsToReact = new PredeterminedActionIterator();
        this.processActions(actions, cause, depth, transactionContext, actionsToReact);
        if (startDupeCheck) {
            transactionContext.setDupeCheck();
        }
        this.processReActions(actionsToReact, depth + 1, transactionContext, transactionContext.getActionContext().getProcessingScope() == ActionContext.ProcessingScope.ALL ? ActionContext.ProcessingScope.ALL : ActionContext.ProcessingScope.MAINPROCESSORS);
    }

    private void processReActions(ActionIterator actionIt, int depth, TransactionContext transactionContext, ActionContext.ProcessingScope processingScope) {
        ActionIterator actionsToReact = actionIt;
        int i = 0;
        ActionContext.ProcessingScope runningProcessingScope = processingScope;
        while (actionsToReact.hasNext() && i < 1000000) {
            if (logger.isDebugEnabled(54)) {
                logger.debug(54, "  <++ get reactions on actions");
            }
            PredeterminedActionIterator actionsToReactNextTime = new PredeterminedActionIterator();
            CompressedActionList compressedAcionList = new CompressedActionList();
            while (actionsToReact.hasNext()) {
                Action actionToReact = actionsToReact.next();
                if (logger.isDebugEnabled(54)) {
                    logger.debug(54, "  +++ get reactions on action: " + actionToReact.toString());
                }
                Collection<IEntryOfCompressedList> reactions = actionToReact.getEntriesForCompressedReactionList();
                for (IEntryOfCompressedList entry : reactions) {
                    if (logger.isDebugEnabled(54)) {
                        logger.debug(54, "  +++ add entry for action: " + actionToReact.toString() + " - " + entry);
                    }
                    compressedAcionList.add(actionToReact, entry);
                }
            }
            compressedAcionList.process(depth, transactionContext, actionsToReactNextTime, runningProcessingScope);
            if (logger.isDebugEnabled(54)) {
                logger.debug(54, "  ++> reaction on actions finished.");
            }
            actionsToReact = actionsToReactNextTime;
            ++i;
            if (runningProcessingScope != ActionContext.ProcessingScope.POSTPROCESSORS) continue;
            runningProcessingScope = ActionContext.ProcessingScope.ALL;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processActions(ActionIterator actions, Action cause, int depth, TransactionContext transactionContext, PredeterminedActionIterator actionsToReact) throws EXActionNotValidException {
        if (!TransactionProcessor.$assertionsDisabled && actions == null) {
            throw new AssertionError((Object)"actions is null");
        }
        if (!TransactionProcessor.$assertionsDisabled && transactionContext == null) {
            throw new AssertionError((Object)"transactionContext is null");
        }
        if (TransactionProcessor.$assertionsDisabled || actionsToReact != null) ** GOTO lbl15
        throw new AssertionError((Object)"actionsToReact is null");
lbl-1000:
        // 1 sources

        {
            action = actions.next();
            this.processTransactionWithOptionalDupeCheck(action.getPreActionIterator(), action, depth, transactionContext, false);
            if (action.validateAction()) {
                if (action.isNop() || this.isDupe(action, transactionContext)) continue;
                this.processAction(action, cause, depth, transactionContext);
                actionsToReact.addAction(action);
                continue;
            }
            throw new EXActionNotValidException();
lbl15:
            // 3 sources

            ** while (actions.hasNext())
        }
lbl16:
        // 1 sources

    }

    private void processAction(Action action, Action cause, int depth, TransactionContext transactionContext) {
        assert (action != null) : "action is null";
        assert (transactionContext != null) : "transactionContext is null";
        assert (action.validateAction()) : "action is not valid";
        if (logger.isDebugEnabled(54)) {
            String spaces = "";
            int i = 0;
            while (i < depth) {
                spaces = String.valueOf(spaces) + "  ";
                ++i;
            }
            if (cause == null) {
                logger.debug(54, String.valueOf(spaces) + "--> execute action: " + action.toString());
            } else {
                logger.debug(54, String.valueOf(spaces) + cause.toString() + " --> causes execution of action: " + action.toString());
            }
        }
        action.dodo();
        transactionContext.pushActionLogEntry(action, cause);
    }

    private boolean isDupe(Action action, TransactionContext transactionContext) {
        assert (action != null) : "action is null";
        assert (transactionContext != null) : "transactionContext is null";
        assert (action.validateAction()) : "action is not valid";
        boolean isDupe = false;
        if (isDupe) {
            logger.warn("FMCA Planmodel transaction processor: Action dupe detected. ");
        }
        return isDupe;
    }

    class CompressedActionList {
        HashMap<IEntryOfCompressedList, Action> compressedList = new HashMap();

        private CompressedActionList() {
        }

        private void add(Action actionToReact, IEntryOfCompressedList listEntry) {
            if (this.compressedList.containsKey(listEntry)) {
                IEntryOfCompressedList entry = null;
                Set<IEntryOfCompressedList> keySet = this.compressedList.keySet();
                for (IEntryOfCompressedList current : keySet) {
                    if (!current.equals(listEntry)) continue;
                    entry = current;
                    break;
                }
                assert (entry != null) : "entry is null";
                entry.compress(listEntry);
            } else {
                this.compressedList.put(listEntry, actionToReact);
            }
        }

        private void process(int depth, TransactionContext transactionContext, PredeterminedActionIterator actionsToReactNextTime, ActionContext.ProcessingScope processingScope) {
            Iterator<IEntryOfCompressedList> iterator = this.compressedList.keySet().iterator();
            while (iterator.hasNext()) {
                IEntryOfCompressedList element;
                IEntryOfCompressedList entryOfCompressedList = element = iterator.next();
                Action actionToReact = this.compressedList.get(entryOfCompressedList);
                if (logger.isDebugEnabled(54)) {
                    logger.debug(54, "  +++ calculate reactions on action: " + actionToReact.toString() + " of type " + entryOfCompressedList.getActionType().getName());
                }
                if (processingScope == ActionContext.ProcessingScope.POSTPROCESSORS) {
                    transactionContext.getActionContext().enablePostProcessorsOnly();
                } else if (processingScope == ActionContext.ProcessingScope.ALL) {
                    transactionContext.getActionContext().enableAllProcessors();
                }
                ActionIterator actionIterator = entryOfCompressedList.getReactions();
                try {
                    if (logger.isDebugEnabled(54)) {
                        logger.debug(54, "  +++ process reactions on action: " + actionToReact.toString() + " of type " + entryOfCompressedList.getActionType().getName());
                    }
                    TransactionProcessor.this.processActions(actionIterator, actionToReact, depth, transactionContext, actionsToReactNextTime);
                }
                catch (EXActionNotValidException e) {
                    logger.error("EXActionNotValidException", (Throwable)e);
                }
            }
        }
    }
}

