/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.implementation.ModelChange;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransactionContext {
    private final ActionContext actionContext;
    private final List<ActionLogEntry> actionLog = new ArrayList<ActionLogEntry>(50);
    private int dupeCheckStartIndex = -1;
    private final Map<IPMSemanticalUnitRW, Set<IModelChangeRW>> structuredModelChanges = new HashMap<IPMSemanticalUnitRW, Set<IModelChangeRW>>(100, 0.5f);
    private final HashMap<PMPlanModelObject, ModifiableInteger> removedPlanModelObjects = new HashMap(100, 0.5f);
    private ModifiableInteger removedPlanModelObjects_removedValueObject = null;

    public TransactionContext(ActionContext actionContext) {
        assert (actionContext != null) : "actionContext is null";
        this.actionContext = actionContext;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    protected int getActionLogSize() {
        return this.actionLog.size();
    }

    protected Action getActionLogEntry(int index) {
        assert (index >= 0 && index < this.getActionLogSize()) : "index out of bounds";
        return this.actionLog.get(index).action;
    }

    protected int getActionLogEntryCause(int index) {
        assert (index >= 0 && index < this.getActionLogSize()) : "index out of bounds";
        Action cause = this.actionLog.get(index).cause;
        int causeIndex = -1;
        int i = 0;
        while (i < this.actionLog.size()) {
            if (this.getActionLogEntry(i) == cause) {
                causeIndex = i;
            }
            ++i;
        }
        return causeIndex;
    }

    protected void setDupeCheck() {
        if (this.dupeCheckStartIndex < 0) {
            this.dupeCheckStartIndex = this.getActionLogSize();
        }
    }

    protected boolean doDupeCheck() {
        return this.dupeCheckStartIndex >= 0;
    }

    protected int getDupeCheckStartIndex() {
        return this.dupeCheckStartIndex;
    }

    protected void pushActionLogEntry(Action action, Action cause) {
        this.actionLog.add(new ActionLogEntry(action, cause));
        Set<IModelChangeRW> modelChanges = this.getRelatedModelChangeSet(action.getSemanticalUnit());
        modelChanges.addAll(action.getChanges());
        for (IModelChangeRW element : modelChanges) {
            ModelChange modelChange = (ModelChange)element;
            if (modelChange.getType() == 1) {
                PMPlanModelObject createdObject = modelChange.getPlanModelObject();
                this.adjustPlanModelObjectCount(createdObject, 1);
                continue;
            }
            if (modelChange.getType() != 3) continue;
            PMPlanModelObject removedObject = modelChange.getPlanModelObject();
            this.adjustPlanModelObjectCount(removedObject, -1);
        }
    }

    protected Action popActionLogEntry() {
        Action action = this.actionLog.remove(this.getActionLogSize() - 1).action;
        Set<IModelChangeRW> modelChanges = this.getRelatedModelChangeSet(action.getSemanticalUnit());
        modelChanges.removeAll(action.getChanges());
        for (IModelChangeRW element : modelChanges) {
            ModelChange modelChange = (ModelChange)element;
            if (modelChange.getType() == 1) {
                PMPlanModelObject createdObject = modelChange.getPlanModelObject();
                this.adjustPlanModelObjectCount(createdObject, -1);
                continue;
            }
            if (modelChange.getType() != 3) continue;
            PMPlanModelObject removedObject = modelChange.getPlanModelObject();
            this.adjustPlanModelObjectCount(removedObject, 1);
        }
        return action;
    }

    private int getPlanModelObjectCount(PMPlanModelObject planModelObject) {
        ModifiableInteger counterInteger = this.removedPlanModelObjects.get(planModelObject);
        int count = 0;
        if (counterInteger != null) {
            count = counterInteger.getValue();
        }
        return count;
    }

    private void adjustPlanModelObjectCount(PMPlanModelObject planModelObject, int adjustment) {
        ModifiableInteger adjustedValueObject;
        if (this.removedPlanModelObjects_removedValueObject != null) {
            adjustedValueObject = this.removedPlanModelObjects_removedValueObject;
            this.removedPlanModelObjects_removedValueObject = null;
        } else {
            adjustedValueObject = new ModifiableInteger();
        }
        ModifiableInteger replacedValueObject = this.removedPlanModelObjects.put(planModelObject, adjustedValueObject);
        int adjustedValue = replacedValueObject != null ? replacedValueObject.getValue() + adjustment : adjustment;
        if (adjustedValue == 0) {
            this.removedPlanModelObjects_removedValueObject = this.removedPlanModelObjects.remove(planModelObject);
        } else {
            adjustedValueObject.setValue(adjustedValue);
            this.removedPlanModelObjects_removedValueObject = replacedValueObject;
        }
    }

    public Map<IPMSemanticalUnitRW, Set<IModelChangeRW>> getStructuredModelChanges() {
        return this.structuredModelChanges;
    }

    public boolean isSemanticalUnitCreated(IPMSemanticalUnitRW semanticalUnit) {
        boolean removed = semanticalUnit instanceof PMPlanModelObject ? this.getPlanModelObjectCount((PMPlanModelObject)((Object)semanticalUnit)) > 0 : false;
        return removed;
    }

    public boolean isSemanticalUnitRemoved(IPMSemanticalUnitRW semanticalUnit) {
        boolean removed = semanticalUnit instanceof PMPlanModelObject ? this.getPlanModelObjectCount((PMPlanModelObject)((Object)semanticalUnit)) < 0 : false;
        return removed;
    }

    private Set<IModelChangeRW> getRelatedModelChangeSet(IPMSemanticalUnitRW semanticalUnit) {
        Set<IModelChangeRW> modelChanges = this.structuredModelChanges.get(semanticalUnit);
        if (modelChanges == null) {
            modelChanges = new HashSet<IModelChangeRW>();
            this.structuredModelChanges.put(semanticalUnit, modelChanges);
        }
        return modelChanges;
    }

    private static class ActionLogEntry {
        private final Action action;
        private final Action cause;

        public ActionLogEntry(Action action, Action cause) {
            this.action = action;
            this.cause = cause;
        }
    }

    private static class ModifiableInteger {
        private int value = 0;

        private ModifiableInteger() {
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

