/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRootMgrRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.access.readwrite.IPlanModelMgrRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.EXActionNotValidException;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import com.arcway.planagent.planmodel.transactions.TransactionContext;
import com.arcway.planagent.planmodel.transactions.TransactionProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Transaction {
    private static final ILogger logger = Logger.getLogger(Transaction.class);
    public static final boolean PRE = false;
    public static final boolean POST = true;
    private static final boolean SWITCH_TO_PRE = false;
    private static final boolean SWITCH_TO_POST = true;
    private static long maxTransactionSerial = 0L;
    private final long transactionSerial = maxTransactionSerial++;
    private final TransactionContext transactionContext;
    private final IPMPlanModelObjectRW transactionRoot;
    private boolean state = false;
    private boolean executed = false;
    private boolean valid = false;
    private boolean firstDoDone = false;
    private EXTransactionNotValidException inValidException = null;

    public Transaction(IPMPlanModelObjectRW relatedPlanModelObject, ActionParameters actionParameters) {
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "=======================================================================================================");
            logger.debug(54, "*** Transaction: constructing " + this.calculateDebugLabel(true) + " *****************");
        }
        assert (relatedPlanModelObject != null) : "relatedPlanModelObject is null";
        ActionContext actionContext = new ActionContext(actionParameters, relatedPlanModelObject.getIPlanModelMgrRW());
        this.transactionContext = new TransactionContext(actionContext);
        this.transactionRoot = relatedPlanModelObject;
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Set<IModelChangeRW> getChanges() {
        void var4_7;
        this.calculateTransaction();
        TransactionContext context = this.getTransactionContext();
        IPMPlanModelObjectFactoryRW planModelObjectFactory = context.getActionContext().getPlanModelObjectFactory();
        HashSet<IModelChangeRW> allActionChanges = new HashSet<IModelChangeRW>();
        for (IPMPlanModelObjectRW iPMPlanModelObjectRW : this.getPrimarilyChangedPlanModelObjects()) {
            allActionChanges.add(planModelObjectFactory.createModelChange(iPMPlanModelObjectRW, 2));
        }
        boolean bl = false;
        while (var4_7 < context.getActionLogSize()) {
            Action action = context.getActionLogEntry((int)var4_7);
            Set<IModelChangeRW> actionChanges = action.getChanges();
            if (actionChanges != null) {
                allActionChanges.addAll(actionChanges);
            }
            ++var4_7;
        }
        return allActionChanges;
    }

    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        return Collections.emptyList();
    }

    public final boolean getState() {
        return this.state;
    }

    public final void setState(boolean newState) {
        assert (this.valid) : "transaction is not valid, or isValid() was not checked by the caller";
        if (this.state != newState) {
            if (newState) {
                this.setToPost();
                this.state = true;
            } else if (!newState) {
                this.setToPre();
                this.state = false;
            }
        }
    }

    public final void dodo() {
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.debug(54, "*** Transaction: dodo() " + this.calculateDebugLabel() + " *****************");
        }
        assert (this.valid) : "transaction is not valid, or isValid() was not checked by the caller";
        if (!this.state) {
            this.setState(true);
            if (!this.firstDoDone) {
                if (this.transactionContext.getActionContext().getProcessingScope() != ActionContext.ProcessingScope.ALL) {
                    this.valid = this.execute(true);
                    if (!this.valid) {
                        logger.error("PlanModel: invalid action processed in postprocessing");
                    }
                }
                this.firstDoDone = true;
            }
            this.fireModelChanged(true);
        }
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "");
        }
    }

    public final void undo() {
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.debug(54, "*** Transaction: undo() " + this.calculateDebugLabel() + " *****************");
        }
        if (this.state) {
            this.setState(false);
            this.fireModelChanged(false);
        }
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "");
        }
    }

    private void fireModelChanged(boolean switchDirection) {
        Set<Map.Entry<IPMSemanticalUnitRW, Set<IModelChangeRW>>> structuredModelChanges = this.getTransactionContext().getStructuredModelChanges().entrySet();
        HashSet<IModelChangeRW> allModelChanges = new HashSet<IModelChangeRW>();
        for (Map.Entry<IPMSemanticalUnitRW, Set<IModelChangeRW>> entry : structuredModelChanges) {
            Set<IModelChangeRW> modelChanges = entry.getValue();
            if (!switchDirection) {
                modelChanges = this.getInverseModelChanges(modelChanges);
            }
            allModelChanges.addAll(modelChanges);
        }
        IModelChangeRootMgrRW rootModelChangeMgr = this.getPlanModelMgr().getModelChangeRootMgrRW();
        rootModelChangeMgr.aboutTofireModelChanges(allModelChanges);
        for (Map.Entry<IPMSemanticalUnitRW, Set<IModelChangeRW>> entry : structuredModelChanges) {
            boolean notify;
            IPMSemanticalUnitRW semanticalUnit = entry.getKey();
            if (switchDirection) {
                notify = !this.getTransactionContext().isSemanticalUnitRemoved(semanticalUnit);
            } else {
                boolean bl = notify = !this.getTransactionContext().isSemanticalUnitCreated(semanticalUnit);
            }
            if (!notify) continue;
            Set<IModelChangeRW> modelChanges = entry.getValue();
            if (!switchDirection) {
                modelChanges = this.getInverseModelChanges(modelChanges);
            }
            semanticalUnit.getModelChangeMgrRW().fireModelChanged(modelChanges);
        }
        rootModelChangeMgr.modelChangesFired(allModelChanges);
    }

    private Set<IModelChangeRW> getInverseModelChanges(Set<? extends IModelChangeRW> modelChanges) {
        HashSet<IModelChangeRW> invertedModelChanges = new HashSet<IModelChangeRW>(modelChanges.size());
        for (IModelChangeRW iModelChangeRW : modelChanges) {
            IModelChangeRW invertedModelChange = iModelChangeRW.getInverted();
            invertedModelChanges.add(invertedModelChange);
        }
        return invertedModelChanges;
    }

    public final boolean isValid() {
        if (this.inValidException != null) {
            this.valid = false;
        } else {
            this.calculateTransaction();
        }
        return this.valid;
    }

    protected final void setInvalid(EXTransactionNotValidException e) {
        assert (e != null) : "e is null; set invalid needs an exception as cause";
        this.inValidException = e;
        logger.debug(54, "Invalid Transaction: ", (Throwable)e);
    }

    protected final void transactionAssertion(boolean condition, String message) {
        if (!condition) {
            this.setInvalid(new EXTransactionNotValidException(message));
        }
    }

    private void calculateTransaction() {
        this.valid = this.getTransactionValidator().validateTransactionPre(this);
        if (this.valid && !this.executed) {
            boolean oldState = this.state;
            this.valid = this.execute(false);
            this.executed = true;
            this.state = this.valid;
            if (this.valid) {
                this.valid = this.getTransactionValidator().validateTransactionPost(this);
                if (!oldState) {
                    this.setToPre();
                    this.state = false;
                }
            }
        }
    }

    private boolean execute(boolean postProcessing) {
        boolean success;
        TransactionProcessor transactionProcessor = TransactionProcessor.getInstance();
        try {
            if (postProcessing) {
                if (logger.isDebugEnabled(54)) {
                    logger.debug(54, "... Transaction: executing " + this.calculateDebugLabel() + "(root: " + this.getTransactionRoot().toString() + ")");
                }
                transactionProcessor.processTransactionPostprocessing(this.transactionContext);
            } else {
                if (logger.isDebugEnabled(54)) {
                    logger.debug(54, "... Transaction: executing " + this.calculateDebugLabel() + "(root: " + this.getTransactionRoot().toString() + ")");
                }
                ActionIterator actions = this.getActionIterator();
                transactionProcessor.processTransaction(actions, this.transactionContext);
            }
            success = true;
        }
        catch (EXActionNotValidException e) {
            logger.warn("Transaction is not valid. ", (Throwable)e);
            this.rollBack();
            success = false;
        }
        catch (Throwable e) {
            logger.error("Exception during execution of transaction. ", e);
            logger.error(this.dump());
            this.rollBack();
            success = false;
        }
        return success;
    }

    private String dump() {
        String transactionDump = "\n ** Transaction Dump of transaction: " + this.calculateDebugLabel() + " **\n";
        int i = 0;
        while (i < this.transactionContext.getActionLogSize()) {
            Action action = this.transactionContext.getActionLogEntry(i);
            transactionDump = String.valueOf(transactionDump) + "  - Action " + i + ", caused by Action " + this.transactionContext.getActionLogEntryCause(i) + ": " + action.toString() + "\n";
            ++i;
        }
        transactionDump = String.valueOf(transactionDump) + " ** end of dump **\n";
        return transactionDump;
    }

    private void rollBack() {
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "... Transaction: roll back " + this.calculateDebugLabel());
        }
        while (this.transactionContext.getActionLogSize() > 0) {
            Action action = this.transactionContext.popActionLogEntry();
            action.undo();
        }
    }

    private void setToPre() {
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "... Transaction: set to pre " + this.calculateDebugLabel());
        }
        int i = this.transactionContext.getActionLogSize() - 1;
        while (i >= 0) {
            Action action = this.transactionContext.getActionLogEntry(i);
            action.undo();
            --i;
        }
    }

    private void setToPost() {
        if (logger.isDebugEnabled(54)) {
            logger.debug(54, "... Transaction: set to post " + this.calculateDebugLabel());
        }
        int i = 0;
        while (i < this.transactionContext.getActionLogSize()) {
            Action action = this.transactionContext.getActionLogEntry(i);
            action.redo();
            ++i;
        }
    }

    private ITransactionValidator getTransactionValidator() {
        return this.getTransactionRoot().getISemanticalUnitRW().getTransactionValidator();
    }

    protected final IPMPlanModelObjectRW getTransactionRoot() {
        return this.transactionRoot;
    }

    protected final TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    protected final IPlanModelMgrRW getPlanModelMgr() {
        return this.getTransactionRoot().getIPlanModelMgrRW();
    }

    protected final ActionContext getActionContext() {
        return this.getTransactionContext().getActionContext();
    }

    private String calculateDebugLabel() {
        return this.calculateDebugLabel(false);
    }

    private String calculateDebugLabel(boolean calledBeforeConstructorCompleted) {
        String label = "#" + this.transactionSerial + " ";
        label = calledBeforeConstructorCompleted ? String.valueOf(label) + this.getClass().getSimpleName() + " - " + Transaction.class.getSimpleName() + ".<init>(...)" : String.valueOf(label) + this.toString();
        return label;
    }

    public abstract ActionIterator getActionIterator();
}

