/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.routing;

import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ConcatenatingActionIterator;
import com.arcway.planagent.planmodel.actions.DelayingActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationVisitor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import java.util.Collection;
import java.util.Collections;

public class RoutingAgent {
    private final IRoutingManager routingManager;

    public RoutingAgent(IRoutingManager routingManager) {
        this.routingManager = routingManager;
    }

    public ActionIterator routeWhileDestinationsHaveChanged(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Collection<? extends IAnchoringSourceContributor> sourceContributorsToIgnore, ActionContext actionContext, IRoutingParameters routingParameters) {
        ConcatenatingActionIterator routingActions = new ConcatenatingActionIterator();
        Collection<? extends IAnchoringSourceContributor> ignorableSourceContributors = sourceContributorsToIgnore;
        if (ignorableSourceContributors == null) {
            ignorableSourceContributors = Collections.emptyList();
        }
        RouteDestinationVisitor visitor = new RouteDestinationVisitor(ignorableSourceContributors, actionContext, routingParameters, routingActions);
        AnchoringContributorTraverser.traverseDestinationsAll(destinationContributors, null, (IAnchoringDestinationVisitor)visitor);
        return routingActions;
    }

    public ActionIterator routeAnchoring(final IAnchoring anchoring, final ActionContext actionContext, final IRoutingParameters routingParameters) {
        DelayingActionIterator delayedRoutingActions = new DelayingActionIterator(){

            @Override
            protected ActionIterator createActionIterator() {
                ActionIterator routingActions;
                if (anchoring.isValid()) {
                    IRouter router = RoutingAgent.this.routingManager.getRouter(anchoring, actionContext.getActionParameters().getRoutingContext());
                    ActionIterator routingActionIterator = router.route(anchoring.getAnchoringSource(), anchoring.getAnchoringDestination(), actionContext, routingParameters, RoutingAgent.this.routingManager);
                    if (routingActionIterator != null) {
                        routingActions = routingActionIterator;
                    } else {
                        PredeterminedActionIterator removeAnchoringActionIterator = new PredeterminedActionIterator(1);
                        Action removeAnchoringAction = ActionFactory.createACRemoveAnchoring(actionContext, anchoring);
                        removeAnchoringActionIterator.addAction(removeAnchoringAction);
                        routingActions = removeAnchoringActionIterator;
                    }
                } else {
                    routingActions = ActionIterator.EMPTY_ACTION_ITERATOR;
                }
                return routingActions;
            }
        };
        return delayedRoutingActions;
    }

    private class RouteDestinationVisitor
    implements IAnchoringDestinationVisitor {
        private final Collection<? extends IAnchoringSourceContributor> sourceContributorsToIgnore;
        private final ActionContext actionContext;
        private final IRoutingParameters routingParameters;
        private final ConcatenatingActionIterator routingActions;

        public RouteDestinationVisitor(Collection<? extends IAnchoringSourceContributor> sourceContributorsToIgnore, ActionContext actionContext, IRoutingParameters routingParameters, ConcatenatingActionIterator routingActions) {
            this.sourceContributorsToIgnore = sourceContributorsToIgnore;
            this.actionContext = actionContext;
            this.routingParameters = routingParameters;
            this.routingActions = routingActions;
        }

        @Override
        public boolean visit(IAnchoringDestination destination) {
            for (IAnchoring iAnchoring : destination.getIAnchorings()) {
                IAnchoringSource source = iAnchoring.getAnchoringSource();
                if (AnchoringContributorTraverser.isSourceContained(this.sourceContributorsToIgnore, source)) continue;
                this.routingActions.addActionIterator(RoutingAgent.this.routeAnchoring(iAnchoring, this.actionContext, this.routingParameters));
            }
            return false;
        }
    }
}

