/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.planmodel.persistent.EOContainment;
import com.arcway.planagent.planmodel.persistent.EOFigure;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOPlanElement
extends EOPlanModelObject {
    private static final String DEFAULT_NAME = "";
    private static final String DEFAULT_TYPE = "";
    private static final String DEFAULT_ASPECTID = "";
    private static final String DEFAULT_ROLE = "";
    private static final String DEFAULT_DESCRIPTION = "";
    public static final String XML_NAME = "planelement";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_ROLE = "role";
    private static final String ATTR_TAG_ASPECTID = "aspectid";
    private static final String ATTR_TAG_TYPE = "type";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private String role = "";
    private String type = "";
    private String name = "";
    private String aspectID = "";
    private String description = "";
    private final ArrayList<EOFigure> figures = new ArrayList();
    private final ArrayList<EOContainment> containments = new ArrayList();

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    public EOPlanElement() {
        super(XML_NAME);
    }

    public EOPlanElement(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOPlanElement newObject = new EOPlanElement();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    protected final void setAttributesFromEO(EOPlanElement sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.role = sourceEO.role;
        this.type = sourceEO.type;
        this.name = sourceEO.name;
        this.aspectID = sourceEO.aspectID;
        this.description = sourceEO.description;
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean knownType = true;
        if (newChild instanceof EOContainment) {
            this.containments.add((EOContainment)newChild);
            this.childHooked((EOContainment)newChild);
        } else if (newChild instanceof EOFigure) {
            this.figures.add((EOFigure)newChild);
            this.childHooked((EOFigure)newChild);
        } else {
            knownType = super.addChildFromXML(newChild);
        }
        return knownType;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (!this.type.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TYPE, this.type);
        }
        if (!this.name.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_NAME, this.name);
        }
        if (!this.aspectID.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ASPECTID, this.aspectID);
        }
        if (!this.role.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ROLE, this.role);
        }
        if (!this.description.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_DESCRIPTION, this.description);
        }
        super.appendAttributesToXML(writeContext);
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        allChildrenReceiver.addAll(this.containments);
        allChildrenReceiver.addAll(this.figures);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_NAME)) {
            this.name = value;
        } else if (name.equals(ATTR_TAG_TYPE)) {
            this.type = value;
        } else if (name.equals(ATTR_TAG_ASPECTID)) {
            this.aspectID = value;
        } else if (name.equals(ATTR_TAG_ROLE)) {
            this.role = value;
        } else if (name.equals(ATTR_TAG_DESCRIPTION)) {
            this.description = value;
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    @Override
    protected boolean forceWritingUIDToXML() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getAspectID() {
        return this.aspectID;
    }

    public String getType() {
        return this.type;
    }

    @Deprecated
    public String getRole() {
        return this.role;
    }

    public String getDescription() {
        return this.description;
    }

    public int getContainmentCount() {
        return this.containments.size();
    }

    public EOContainment getContainment(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getContainmentCount()) : "i >= getContainmentCount()";
        return this.containments.get(i);
    }

    public int getFigureCount() {
        return this.figures.size();
    }

    public EOFigure getFigure(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getFigureCount()) : "i >= getFigureCount()";
        return this.figures.get(i);
    }

    public List<EOFigure> getFigures(String figureRole) {
        assert (figureRole != null) : "role is null";
        ArrayList<EOFigure> list = new ArrayList<EOFigure>();
        int i = 0;
        while (i < this.getFigureCount()) {
            EOFigure figure = this.figures.get(i);
            if (figure.getRole().equals(figureRole)) {
                list.add(figure);
            }
            ++i;
        }
        return list;
    }

    public void setName(String name) {
        this.name = StringUtil.removeLineBreaksAndControlCharacters((String)name);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAspectID(String aspectID) {
        this.aspectID = StringUtil.removeLineBreaksAndControlCharacters((String)aspectID);
    }

    @Deprecated
    public void setRole(String role) {
        this.role = role;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addContainment(EOContainment containment, int i) {
        assert (containment != null) : "containment is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.getContainmentCount()) : "i > getContainmentCount()";
        this.containments.add(i, containment);
        this.childHooked(containment);
    }

    public void removeContainment(EOContainment containment) {
        assert (containment != null) : "containment is null";
        assert (this.containments.indexOf((Object)containment) != -1) : "containment is not related to this plan element";
        this.containments.remove((Object)containment);
        this.childUnhooked(containment);
    }

    public void removeContainment(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getContainmentCount()) : "i >= getContainmentCount()";
        EOContainment containment = this.containments.remove(i);
        this.childUnhooked(containment);
    }

    public void addFigure(EOFigure figure, int i) {
        assert (figure != null) : "figure is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.getFigureCount()) : "i > getFigureCount()";
        this.figures.add(i, figure);
        this.childHooked(figure);
    }

    public void removeFigure(EOFigure figure) {
        assert (figure != null) : "figure is null";
        assert (this.figures.indexOf((Object)figure) != -1) : "figure is not related to this plan element";
        this.figures.remove((Object)figure);
        this.childUnhooked(figure);
    }

    public void removeFigure(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getFigureCount()) : "i >= getFigureCount()";
        EOFigure figure = this.figures.remove(i);
        this.childUnhooked(figure);
    }

    public void reorderFigure(int i, int newSuccessor) {
        int successor = newSuccessor;
        assert (i >= 0) : "i<0";
        assert (i < this.getFigureCount()) : "i >= getFigureCount()";
        assert (newSuccessor >= 0) : "insertBefore<0";
        assert (newSuccessor <= this.getFigureCount()) : "insertBefore > getFigureCount()";
        EOFigure toMove = this.getFigure(i);
        this.removeFigure(i);
        if (successor > i) {
            --successor;
        }
        this.addFigure(toMove, successor);
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOPlanElement(xmlContext);
        }
    }
}

