/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public final class EOPlan
extends EOPlanModelObject {
    private static final String DEFAULT_NAME = "FMC plan";
    private static final String DEFAULT_TYPE = "";
    private static final int DEFAULT_FORMAT = 0;
    public static final String XML_NAMESPACE = "http://plans.de/fmca/plan";
    public static final String XML_TAGPREFIX = "";
    public static final String XML_NAME = "plan";
    private static final String XML_ATTR_TAG_NAMESPACE = "xmlns";
    private static final String ATTR_TAG_TYPE = "type";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_FORMAT = "format";
    private String type = "";
    private String planName = "FMC plan";
    private final ArrayList<EOPlanElement> planElements = new ArrayList();
    private int format = 0;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    public EOPlan() {
        super(XML_NAME);
    }

    public EOPlan(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOPlan newObject = new EOPlan();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    public EOPlan getCopy() {
        EOPlan newPlan = null;
        newPlan = (EOPlan)this.getDeepCopy(null);
        return newPlan;
    }

    protected final void setAttributesFromEO(EOPlan sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.type = sourceEO.type;
        this.planName = sourceEO.planName;
        this.format = sourceEO.format;
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean knownType = true;
        if (newChild instanceof EOPlanElement) {
            this.planElements.add((EOPlanElement)newChild);
            this.childHooked((EOPlanElement)newChild);
        } else {
            knownType = super.addChildFromXML(newChild);
        }
        return knownType;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, XML_ATTR_TAG_NAMESPACE, XML_NAMESPACE);
        super.appendAttributesToXML(writeContext);
        if (!this.type.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TYPE, this.type);
        }
        if (!this.planName.equals(DEFAULT_NAME)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_NAME, this.planName);
        }
        if (this.format != 0) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FORMAT, this.format);
        }
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        allChildrenReceiver.addAll(this.planElements);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_TYPE)) {
            this.type = value;
        } else if (name.equals(ATTR_TAG_NAME)) {
            this.planName = value;
        } else if (name.equals(ATTR_TAG_FORMAT)) {
            this.format = Integer.parseInt(value);
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    @Override
    protected boolean forceWritingUIDToXML() {
        return true;
    }

    public int getFormat() {
        return this.format;
    }

    public String getName() {
        return this.planName;
    }

    public String getType() {
        return this.type;
    }

    public int getPlanElementCount() {
        return this.planElements.size();
    }

    public EOPlanElement getPlanElement(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getPlanElementCount()) : "i >= getPlanElementCount()";
        return this.planElements.get(i);
    }

    public void setName(String name) {
        this.planName = StringUtil.removeLineBreaksAndControlCharacters((String)name);
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addPlanElement(EOPlanElement planElement, int i) {
        assert (planElement != null) : "planElement is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.getPlanElementCount()) : "i > getPlanElementCount()";
        this.planElements.add(i, planElement);
        this.childHooked(planElement);
    }

    public void removePlanElement(EOPlanElement planElement) {
        assert (planElement != null) : "planElement is null";
        assert (this.planElements.indexOf((Object)planElement) != -1) : "planElement is not related to this plan";
        this.planElements.remove((Object)planElement);
        this.childUnhooked(planElement);
    }

    public void removePlanElement(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getPlanElementCount()) : "i >= getPlanElementCount()";
        EOPlanElement planElement = this.planElements.remove(i);
        this.childUnhooked(planElement);
    }

    public void reorderPlanElement(int i, int newSuccessor) {
        assert (i >= 0) : "i<0";
        assert (i < this.getPlanElementCount()) : "i >= getPlanElementCount()";
        assert (newSuccessor >= 0) : "insertBefore<0";
        assert (newSuccessor <= this.getPlanElementCount()) : "insertBefore > getPlanElementCount()";
        EOPlanElement toMove = this.getPlanElement(i);
        this.removePlanElement(i);
        if (newSuccessor > i) {
            this.addPlanElement(toMove, newSuccessor - 1);
        } else {
            this.addPlanElement(toMove, newSuccessor);
        }
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOPlan(xmlContext);
        }
    }
}

