/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPoint;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPointToPoint;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.List;

public class PMAnchoringPointToPoint
extends PMAnchoringPoint
implements IPMAnchoringPointToPointRO,
IPMAnchoringPointToPointRW {
    private PMPoint targetPoint = null;
    private final EOAnchoringPointToPoint persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOAnchoringPointToPoint.class, new AnchoringPointToPointFactory());
    }

    protected PMAnchoringPointToPoint(PlanModelMgr planModelMgr, EOAnchoringPointToPoint eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOAnchoringPointToPoint getPersistentAnchoringPointToPoint() {
        return this.persistent;
    }

    @Override
    protected EOAnchoringPoint getPersistentAnchoringPoint() {
        return this.getPersistentAnchoringPointToPoint();
    }

    protected PMAnchoringPointToPoint(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToPoint();
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) throws EXPlanModelObjectCrosslinkException {
        PMPoint point = (PMPoint)LoadPlanModelObjectLinker.getObjectByUIDAndCheckType(objectList, this.getPersistentAnchoringPointToPoint().getPointUid(), PMPoint.class, "point");
        point.linkCrossLinkToPointToPointAnchoring(this);
        this.targetPoint = point;
    }

    @Override
    protected List<PMPoint> getCrosslinked() {
        List crosslinked = super.getCrosslinked();
        crosslinked.add(this.targetPoint);
        return crosslinked;
    }

    public PMPoint getTargetPoint() {
        return this.targetPoint;
    }

    @Override
    public IPMPointRO getTargetPointRO() {
        return this.getTargetPoint();
    }

    @Override
    public IPMPointRW getTargetPointRW() {
        return this.getTargetPoint();
    }

    public void setTargetPoint(PMPoint point) {
        this.setTargetPoint((Object)point);
    }

    @Override
    public void setTargetPoint(IPMPointRW point) {
        this.setTargetPoint((Object)point);
    }

    private void setTargetPoint(Object point) {
        PMPoint pMPoint;
        assert (point == null || point instanceof PMPoint) : "point is not instance of PMPoint";
        this.targetPoint = pMPoint = (PMPoint)point;
        if (point == null) {
            this.getPersistentAnchoringPointToPoint().setPointUid(null);
        } else {
            this.getPersistentAnchoringPointToPoint().setPointUid(pMPoint.getPersistentPoint().getUid());
        }
    }

    protected PMAnchoringPointToPoint(PlanModelMgr planModelMgr, PMPoint point, PMPoint targetPoint) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToPoint();
        this.constructPMAnchoring(point);
        this.setTargetPoint(targetPoint);
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        this.setTargetPoint(null);
    }

    @Override
    public void delete() {
        super.delete();
        if (this.getTargetPoint() != null) {
            this.getTargetPoint().setAnchoring(null);
            this.setTargetPoint(null);
        }
    }

    @Override
    public IAnchoringDestination getAnchoringDestination() {
        return this.getAnchoringDestinationPoint();
    }

    @Override
    public IAnchoringDestinationPoint getAnchoringDestinationPoint() {
        return this.getTargetPoint();
    }

    @Override
    public boolean isDesirable() {
        return this.getPoint().getPlanElement().getPlan().getAnchoringDecider().isDesirableAnchoring(this.getAnchoringSource(), this.getAnchoringDestination());
    }

    @Override
    public boolean isValid() {
        if (this.getPoint() == null || this.getPoint().getAnchoring() != this) {
            return false;
        }
        return this.getTargetPoint() != null && this.getTargetPoint().getAnchoringIndex(this) >= 0;
    }

    static class AnchoringPointToPointFactory
    extends PMAnchoringPoint.AnchoringPointFactory {
        AnchoringPointToPointFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMAnchoringPointToPoint(planModelMgr, (EOAnchoringPointToPoint)eo);
        }

        @Override
        public List getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

