/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IModelChangeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanModelObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;

public class ModelChange
implements IModelChangeRO,
IModelChangeRW {
    public static final int CREATED = 1;
    public static final int CHANGED = 2;
    public static final int REMOVED = 3;
    private final int type;
    private final PMPlanModelObject planModelObject;

    protected ModelChange(IPMPlanModelObjectRW planModelObject, int type) {
        assert (planModelObject instanceof PMPlanModelObject) : "planModelObject is not of type PMPlanModelObject";
        this.planModelObject = (PMPlanModelObject)planModelObject;
        this.type = type;
    }

    @Override
    public IModelChangeRW getInverted() {
        return new ModelChange(this.planModelObject, this.getTypeInverted());
    }

    public PMPlanModelObject getPlanModelObject() {
        return this.planModelObject;
    }

    @Override
    public IPMPlanModelObjectRO getPlanModelObjectRO() {
        return this.getPlanModelObject();
    }

    @Override
    public IPMPlanModelObjectRW getPlanModelObjectRW() {
        return this.getPlanModelObject();
    }

    @Override
    public int getType() {
        return this.type;
    }

    private int getTypeInverted() {
        int invertedType;
        switch (this.type) {
            case 1: {
                invertedType = 3;
                break;
            }
            case 2: {
                invertedType = 2;
                break;
            }
            case 3: {
                invertedType = 1;
                break;
            }
            default: {
                invertedType = 2;
                assert (false) : "unknown type";
                break;
            }
        }
        return invertedType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModelChange) {
            ModelChange a = (ModelChange)obj;
            if (this.type != a.type) {
                return false;
            }
            return this.planModelObject.equals(((ModelChange)obj).planModelObject);
        }
        return false;
    }

    public int hashCode() {
        return this.type ^ this.planModelObject.hashCode();
    }

    public String toString() {
        String typeString;
        switch (this.type) {
            case 1: {
                typeString = "created";
                break;
            }
            case 2: {
                typeString = "changed";
                break;
            }
            case 3: {
                typeString = "removed";
                break;
            }
            default: {
                typeString = "unknown Type";
            }
        }
        return String.valueOf(this.planModelObject.toString()) + " (" + typeString + ")";
    }
}

