/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.appearance;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;

public class TextAppearance
implements ITextAppearance {
    private int alignmentH = 2;
    private int alignmentV = 16;
    private Direction direction = DEFAULT_DIRECITON;
    private Insets insets = new Insets(DEFAULT_INSETS);
    private String fontName = "Arial";
    private boolean bold = false;
    private boolean italic = false;
    private double textLineHeight = 4.5;
    private int textColorRed = 0;
    private int textColorGreen = 0;
    private int textColorBlue = 0;
    private boolean textColorTransparent = false;

    public static void copy(ITextAppearanceRO source, ITextAppearance target) {
        target.setTextStyle(source.getTextStyle());
        target.setTextLineHeight(source.getTextLineHeight());
        target.setTextColor(source.getTextColor());
        target.setAlignment(source.getAlignment());
        target.setDirection(source.getDirection());
        target.setInsets(source.getInsets());
    }

    public TextAppearance() {
    }

    public TextAppearance(ITextAppearanceRO source) {
        this.setAppearanceFrom(source);
    }

    @Override
    public Alignment getAlignment() {
        return new Alignment(this.alignmentH, this.alignmentV);
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.insets);
    }

    @Override
    public TextStyle getTextStyle() {
        return new TextStyle(this.fontName, this.bold, this.italic);
    }

    @Override
    public double getTextLineHeight() {
        return this.textLineHeight;
    }

    @Override
    public Color getTextColor() {
        if (this.textColorTransparent) {
            return new Color(Color.TRANSPARENT);
        }
        return new Color(this.textColorRed, this.textColorGreen, this.textColorBlue);
    }

    @Override
    public void setAlignment(Alignment alignment) {
        assert (alignment != null);
        this.alignmentH = alignment.h;
        this.alignmentV = alignment.v;
    }

    @Override
    public void setDirection(Direction direction) {
        assert (direction != null);
        this.direction = direction;
    }

    @Override
    public void setInsets(Insets insets) {
        assert (insets != null);
        this.insets = new Insets(insets);
    }

    @Override
    public void setTextStyle(TextStyle textStyle) {
        assert (textStyle != null);
        this.fontName = textStyle.getFontName();
        this.bold = textStyle.isBold();
        this.italic = textStyle.isItalic();
    }

    @Override
    public void setTextLineHeight(double textHeigth) {
        assert (textHeigth > -1.0E-10);
        this.textLineHeight = textHeigth;
    }

    @Override
    public void setTextColor(Color textColor) {
        assert (textColor != null);
        this.textColorRed = textColor.r;
        this.textColorGreen = textColor.g;
        this.textColorBlue = textColor.b;
        this.textColorTransparent = textColor.transparent;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof ITextAppearanceRO)) {
            return;
        }
        ITextAppearanceRO text = (ITextAppearanceRO)appearance;
        this.setAlignment(text.getAlignment());
        this.setDirection(text.getDirection());
        this.setInsets(text.getInsets());
        this.setTextColor(text.getTextColor());
        this.setTextLineHeight(text.getTextLineHeight());
        this.setTextStyle(text.getTextStyle());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new TextAppearance(this);
    }
}

