/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACRemovePlanObject;
import com.arcway.planagent.planmodel.actions.ACRemoveReference;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACRemoveGraphicalSupplement
extends ACRemovePlanObject {
    private final IPMGraphicalSupplementRW graphicalSupplement;
    private IPMFigureRW figure;
    private int index;

    public ACRemoveGraphicalSupplement(ActionContext actionContext, IPMGraphicalSupplementRW graphicalSupplement) {
        super(actionContext);
        assert (graphicalSupplement != null) : "ref to graphicalSupplement is null";
        this.graphicalSupplement = graphicalSupplement;
    }

    @Override
    protected void initializeState() {
        this.figure = this.graphicalSupplement.getFigureRW();
        this.index = this.figure.getGraphicalSupplementIndex(this.graphicalSupplement);
    }

    @Override
    protected void setStateToPost() {
        this.figure.removeGraphicalSupplement(this.index);
    }

    @Override
    protected void setStateToPre() {
        this.figure.addGraphicalSupplement(this.graphicalSupplement, this.index);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveGraphicalSupplement dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveGraphicalSupplement && (dupeA = (ACRemoveGraphicalSupplement)a).getGraphicalSupplement() == this.getGraphicalSupplement()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        PredeterminedActionIterator preActions = new PredeterminedActionIterator(this.graphicalSupplement.getReferenceCount());
        int i = 0;
        while (i < this.graphicalSupplement.getReferenceCount()) {
            preActions.addAction(new ACRemoveReference(this.getActionContext(), this.graphicalSupplement.getReferenceRW(i)));
            ++i;
        }
        return preActions;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.graphicalSupplement, 3));
        return changes;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionDeleteSupplementAgent().getEntryForCompressedList(Collections.singletonList(this.graphicalSupplement), this.getActionContext()));
        return reactions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.graphicalSupplement.getFigureRW().getPlanElementRW();
    }

    public IPMGraphicalSupplementRW getGraphicalSupplement() {
        return this.graphicalSupplement;
    }

    public String toString() {
        return "ACRemoveGraphicalSupplement (graphical supplement " + this.graphicalSupplement + ")";
    }
}

