/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringPoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import de.plans.lib.util.Ass;
import java.util.HashSet;
import java.util.Set;

public class ACRemoveAnchoringPointToFigure
extends ACRemoveAnchoringPoint {
    private IPMFigureRW figure;
    private int index;

    public ACRemoveAnchoringPointToFigure(ActionContext actionContext, IPMAnchoringPointToFigureRW anchoringPointToFigure) {
        super(actionContext, anchoringPointToFigure);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveAnchoringPointToFigure dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveAnchoringPointToFigure && (dupeA = (ACRemoveAnchoringPointToFigure)a).getAnchoringPointToFigure() == this.getAnchoringPointToFigure()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    protected void initializeState() {
        this.figure = this.getAnchoringPointToFigure().getFigureRW();
        super.initializeState();
        this.index = this.figure.getAnchoringIndex(this.getAnchoringPointToFigure());
        if (this.index < 0) {
            logger.warn("figure is not related to anchoring!" + this);
            Ass.ert((boolean)false);
        }
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        this.figure.addAnchoring(this.getAnchoringPointToFigure(), this.index);
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        assert (this.index == this.figure.getAnchoringIndex(this.getAnchoringPointToFigure())) : "anchoring is not at the expected index";
        this.figure.removeAnchoring(this.index);
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.getAnchoringPointToFigure(), 3));
        return changes;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getAnchoringPointToFigure().getFigureRW().getPlanElementRW().getPlanRW() == this.getAnchoringPointToFigure().getPointRW().getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getAnchoringPointToFigure().getFigureRW().getPlanElementRW().getPlanRW();
    }

    public IPMAnchoringPointToFigureRW getAnchoringPointToFigure() {
        return (IPMAnchoringPointToFigureRW)this.getAnchoringPoint();
    }

    public String toString() {
        IPMPointRW point;
        String text = "ACRemoveAnchoringPointToFigure ()";
        IPMFigureRW figureRW = this.getAnchoringPointToFigure().getFigureRW();
        if (figureRW != null) {
            text = String.valueOf(text) + ", Figure: " + figureRW;
        }
        if ((point = this.getAnchoringPointToFigure().getPointRW()) != null) {
            text = String.valueOf(text) + ", Point: " + point;
        }
        if (figureRW != null) {
            text = String.valueOf(text) + ", acnhorings to figure: ";
            int i = 0;
            while (i < figureRW.getAnchoringCount()) {
                IPMPointRW ap = figureRW.getAnchoringRW(i).getPointRW();
                text = String.valueOf(text) + ", " + ap;
                ++i;
            }
        }
        return text;
    }
}

