/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementMarkerRW;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRACreateAnchoring;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDObjectRW;
import java.util.List;

public class RAFixUMLSDObjectWithCross
implements IRAChangeGeometryFigure,
IRAMoveFigure,
IRACreateAnchoring {
    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext context) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4 * figureMovements.size());
        for (IPMFigureRW figure : figureMovements) {
            this.addFixActions(figure, context, actions);
        }
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    public ActionIterator createReactionsAnchoringCreated(IAnchoring createdAnchoring, ActionContext context) {
        IPMFigureRW figure = (IPMFigureRW)createdAnchoring.getAnchoringSource().getAnchoringFigure();
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4);
        this.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMPlanElementUMLSDObjectRW object;
        IPMGraphicalSupplementMarkerRW cross;
        IPMFigureLineShapeRW lifeline = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementUMLSDObjectRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigureLineShapeRW)) {
            route &= false;
        }
        if (route) {
            IPMFigureLineShapeRW lineShape = (IPMFigureLineShapeRW)figure;
            if (!lineShape.getRole().equals("lifeline")) {
                route &= false;
            }
            if (route) {
                lifeline = lineShape;
            }
        }
        if (lifeline != null && (cross = (object = (IPMPlanElementUMLSDObjectRW)figure.getPlanElementRW()).getMarkerSupplementRW()) != null) {
            boolean removeSourceAnchorings = false;
            GeoVector distanceToMove = new GeoVector(cross.getPointListRW().getPointRW(0).getPosition(), object.getLifeLineEndPointRW().getPosition());
            ACMovePoint movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)cross.getPointListRW().getPointRW(0), (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
            actions.addAction((Action)movePointAction);
        }
    }
}

