/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.implementation;

import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementMarkerRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementMarkerRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementMarker;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToFigure;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigureLineShape;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.transactions.ForceValidFiguresTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDObjectRO;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDObjectRW;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementUMLSDObject
extends PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementUMLSDObjectRO,
IPMPlanElementUMLSDObjectRW {
    public static final String XML_TYPE = "uml.sd.object";
    public static final String XML_LIFELINE_ROLE = "lifeline";
    public static final String XML_SUPPLEMENT_CROSS_ROLE = "cross";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";
    private final ITransactionValidator transactionValidator = new ForceValidFiguresTransactionValidator((IPMPlanElementRO)this){

        protected boolean isPlanObjectOk(IPMPlanObjectRO planObject) {
            boolean isPlanObjectOk = super.isPlanObjectOk(planObject);
            if (isPlanObjectOk && planObject instanceof PMFigureLineShape) {
                isPlanObjectOk &= planObject.getPointListRO().getPointCount() == 2;
            }
            if (isPlanObjectOk && planObject instanceof PMFigurePlane) {
                isPlanObjectOk &= planObject.getPointListRO().getPointCount() == 4;
            }
            return isPlanObjectOk;
        }
    };

    @Deprecated
    public PMPlanElementUMLSDObject(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    @Deprecated
    public PMPlanElementUMLSDObject(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public TopologyType getToplogyType() {
        return TopologyType.FLAT;
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }

    public ITransactionValidator getTransactionValidator() {
        return this.transactionValidator;
    }

    public Collection getEditFigures() {
        return Collections.singleton(this.getOutlineFigure());
    }

    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null) : "ref to graphSuppl is null";
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW())) : "the graSuppl does not belong to this planelement";
        return super.getResizeSupplementRouter(graphSuppl);
    }

    @Override
    public IPMFigureLineShapeRO getLifeLineRO() {
        return this.getLifeLine();
    }

    @Override
    public IPMFigureLineShapeRW getLifeLineRW() {
        return this.getLifeLine();
    }

    private PMFigureLineShape getLifeLine() {
        List edges = this.getFiguresRO(XML_LIFELINE_ROLE);
        if (edges.size() == 0) {
            return null;
        }
        assert (edges.get(0) instanceof PMFigureLineShape) : "edges.get(0) returned an object that is not of type PMFigureLineShape.";
        assert (edges.size() == 1) : "more than one edge found";
        return (PMFigureLineShape)edges.get(0);
    }

    public PMPoint getLifeLineStartPoint() {
        Object destinationPlanObject;
        PMPoint startPoint = this.getLifeLine().getPointList().getPoint(0);
        PMPoint endPoint = this.getLifeLine().getPointList().getPoint(this.getLifeLine().getPointList().getPointCount() - 1);
        PMAnchoringPoint anchoringStartPoint = startPoint.getAnchoring();
        PMPoint lifeLineStartPoint = anchoringStartPoint != null ? ((destinationPlanObject = anchoringStartPoint instanceof PMAnchoringPointToAnchor ? ((PMAnchoringPointToAnchor)anchoringStartPoint).getAnchor().getLine().getPointList().getPlanObject() : (anchoringStartPoint instanceof PMAnchoringPointToFigure ? ((PMAnchoringPointToFigure)anchoringStartPoint).getFigure() : null)) != this.getOutlineFigure() ? endPoint : startPoint) : endPoint;
        return lifeLineStartPoint;
    }

    @Override
    public IPMPointRO getLifeLineStartPointRO() {
        return this.getLifeLineStartPoint();
    }

    @Override
    public IPMPointRW getLifeLineStartPointRW() {
        return this.getLifeLineStartPoint();
    }

    private PMPoint getLifeLineEndPoint() {
        Object destinationPlanObject;
        PMPoint startPoint = this.getLifeLine().getPointList().getPoint(0);
        PMPoint endPoint = this.getLifeLine().getPointList().getPoint(this.getLifeLine().getPointList().getPointCount() - 1);
        PMAnchoringPoint anchoringStartPoint = startPoint.getAnchoring();
        PMPoint lifeLineEndPoint = anchoringStartPoint != null ? ((destinationPlanObject = anchoringStartPoint instanceof PMAnchoringPointToAnchor ? ((PMAnchoringPointToAnchor)anchoringStartPoint).getAnchor().getLine().getPointList().getPlanObject() : (anchoringStartPoint instanceof PMAnchoringPointToFigure ? ((PMAnchoringPointToFigure)anchoringStartPoint).getFigure() : null)) != this.getOutlineFigure() ? startPoint : endPoint) : startPoint;
        return lifeLineEndPoint;
    }

    @Override
    public IPMPointRO getLifeLineEndPointRO() {
        return this.getLifeLineEndPoint();
    }

    @Override
    public IPMPointRW getLifeLineEndPointRW() {
        return this.getLifeLineEndPoint();
    }

    private PMGraphicalSupplementMarker getMarkerSupplement() {
        PMFigureLineShape boxFigure = this.getLifeLine();
        assert (boxFigure != null);
        List supplementRefs = boxFigure.getGraphicalSupplements(XML_SUPPLEMENT_CROSS_ROLE);
        assert (supplementRefs != null) : "supplementRefs is NULL.";
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1) : "supplementRefs does not contain exactly one element";
        return (PMGraphicalSupplementMarker)supplementRefs.get(0);
    }

    public IPMGraphicalSupplementMarkerRW getMarkerSupplementRW() {
        return this.getMarkerSupplement();
    }

    public IPMGraphicalSupplementMarkerRO getMarkerSupplementRO() {
        return this.getMarkerSupplement();
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getOutlineFigureRW();
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = (PMFigure)this.getOutlineFigure();
        assert (outlineFigure != null);
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        assert (supplementRefs != null);
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1);
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }
}

