/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.transactions;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMReferenceGraphicalSupplementToFigureRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigureLineShape;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.ACRemoveFigure;
import com.arcway.planagent.planmodel.actions.ACRemoveReference;
import com.arcway.planagent.planmodel.actions.ACReorderPlanElementStructure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readwrite.IPMGraphicalSupplementFMCBDRequestSymbolRW;
import com.arcway.planagent.planmodel.fmc.bd.access.readwrite.IPMPlanElementFMCBDChannelRW;
import com.arcway.planagent.planmodel.fmc.bd.access.readwrite.IPMPlanElementFMCBDStorageAccessRW;
import com.arcway.planagent.planmodel.fmc.bd.actions.ACSetFMCBDGraphicalSupplementRequestSymbolDirection;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToFigure;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToLine;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToPoint;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PMReferenceGraphicalSupplementToFigure;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TAMigrateFMCBDChannel
extends PredeterminedLengthTransaction {
    private static final ILogger logger = Logger.getLogger(TAMigrateFMCBDChannel.class);
    private static final int REQUEST_SYMBOL_MIGRATION_STEPS = 3;
    private static final int EDGE_CONVERSION_STEPS = 4;
    private final IPMPlanElementFMCBDChannelRW channel;
    private final boolean isRequestSymbolToBeMigrated;
    private final int nrOfEdgesToBeConverted;
    private ACCreatePlanElement lastStorageAccessCreationAction = null;
    private Points storageAccessPoints;
    private int[] storageAccessLineForce;
    private ILineAppearanceRO storageAccessLineAppearance;
    private ILineMarkerAppearanceRO storageAccessStartMarkerAppearance;
    private ILineMarkerAppearanceRO storageAccessEndMarkerAppearance;

    private static int countSteps(IPMPlanElementFMCBDChannelRW channel) {
        int steps = 0;
        if (TAMigrateFMCBDChannel.isRequestSymbolToBeMigrated(channel)) {
            steps += 3;
        }
        return steps += TAMigrateFMCBDChannel.nrOfEdgesToBeConverted(channel) * 4;
    }

    private static boolean isRequestSymbolToBeMigrated(IPMPlanElementFMCBDChannelRW channel) {
        IPMGraphicalSupplementFMCBDRequestSymbolRW requestSymbolRW = channel.getRequestSymbolRW();
        return requestSymbolRW == null ? false : requestSymbolRW.getReferenceCount() > 0;
    }

    private static int nrOfEdgesToBeConverted(IPMPlanElementFMCBDChannelRW channel) {
        return channel.getFiguresRW("edge").size();
    }

    public TAMigrateFMCBDChannel(IPMPlanElementFMCBDChannelRW channel, ActionParameters actionParameters) {
        super(TAMigrateFMCBDChannel.countSteps(channel), (IPMPlanModelObjectRW)channel, actionParameters);
        this.channel = channel;
        this.isRequestSymbolToBeMigrated = TAMigrateFMCBDChannel.isRequestSymbolToBeMigrated(channel);
        this.nrOfEdgesToBeConverted = TAMigrateFMCBDChannel.nrOfEdgesToBeConverted(channel);
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        Action action = null;
        int relativeActionIndex = n;
        if (this.isRequestSymbolToBeMigrated && relativeActionIndex < 3) {
            action = this.createRequestSymbolMigrationAction(relativeActionIndex);
        } else {
            if (this.isRequestSymbolToBeMigrated) {
                relativeActionIndex -= 3;
            }
            int nrOfEdgesToBeConvertedRest = this.nrOfEdgesToBeConverted;
            while (relativeActionIndex >= 4 && nrOfEdgesToBeConvertedRest > 0) {
                relativeActionIndex -= 4;
                --nrOfEdgesToBeConvertedRest;
            }
            if (nrOfEdgesToBeConvertedRest > 0) {
                action = this.createEdgeConversionAction(relativeActionIndex);
            }
        }
        return action;
    }

    private Action createRequestSymbolMigrationAction(int relativeActionIndex) {
        ACSetFMCBDGraphicalSupplementRequestSymbolDirection action;
        switch (relativeActionIndex) {
            case 0: {
                IPMGraphicalSupplementFMCBDRequestSymbolRW requestSymbol = this.channel.getRequestSymbolRW();
                Direction direction = TAMigrateFMCBDChannel.getDirectionOfRequestSymbol(requestSymbol);
                action = new ACSetFMCBDGraphicalSupplementRequestSymbolDirection(this.getActionContext(), requestSymbol, direction);
                break;
            }
            case 1: 
            case 2: {
                IPMGraphicalSupplementFMCBDRequestSymbolRW requestSymbol = this.channel.getRequestSymbolRW();
                IPMReferenceGraphicalSupplementToFigureRW reference = requestSymbol.getReferenceRW(0);
                action = new ACRemoveReference(this.getActionContext(), reference);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return action;
    }

    private static Direction getDirectionOfRequestSymbol(IPMGraphicalSupplementFMCBDRequestSymbolRW requestSymbol) {
        IPMFigureRO parentFigure = requestSymbol.getFigureRO();
        PMPoint sourcePoint = TAMigrateFMCBDChannel.getAnchoringPoint(requestSymbol, parentFigure, "source");
        PMPoint destinationPoint = TAMigrateFMCBDChannel.getAnchoringPoint(requestSymbol, parentFigure, "destination");
        Point sourcePosition = Point.ORIGIN;
        Point destinationPositon = Point.ORIGIN;
        if (sourcePoint != null) {
            sourcePosition = sourcePoint.getPosition();
        } else {
            logger.error("source point request symbol of channel is null: " + parentFigure.getPlanElementRO().getUid());
        }
        if (destinationPoint != null) {
            destinationPositon = destinationPoint.getPosition();
        } else {
            logger.error("destination point request symbol of channel is null: " + parentFigure.getPlanElementRO().getUid());
        }
        double alpha = Math.abs(sourcePosition.x - destinationPositon.x) > 1.0E-10 ? Math.toRadians(GeoVector.getDifferenceVectorAngle((Point)sourcePosition, (Point)destinationPositon)) : (sourcePosition.y > destinationPositon.y ? 1.5707963267948966 : -1.5707963267948966);
        double alphaInDegrees = Math.toDegrees(alpha);
        Direction direction = Direction.valueOf((double)alphaInDegrees);
        return direction;
    }

    private static PMPoint getAnchoringPoint(IPMGraphicalSupplementFMCBDRequestSymbolRW modelGraphicalSupplementRequestSymbol, IPMFigureRO parentFigure, String role) {
        PMFigure targetFigure;
        PMPlanObject targetPlanObject;
        PMFigure targetFigure2;
        PMPlanObject targetPlanObject2;
        PMFigure targetFigure3;
        List refs = modelGraphicalSupplementRequestSymbol.getReferences(role);
        assert (refs != null) : "refs is NULL.";
        PMReferenceGraphicalSupplementToFigure ref = (PMReferenceGraphicalSupplementToFigure)refs.get(0);
        assert (ref != null) : "ref is NULL.";
        PMFigure figure = ref.getFigure();
        assert (figure != null) : "figure is NULL";
        PMPointList pointList = figure.getPointList();
        assert (pointList != null) : "pointList is NULL";
        assert (pointList.getPointCount() - 1 >= 0) : "pointList contains no elements.";
        PMPoint startPoint = pointList.getPoint(0);
        PMPoint endPoint = pointList.getPoint(pointList.getPointCount() - 1);
        assert (startPoint != null) : "startPoint is NULL.";
        assert (endPoint != null) : "endPoint is NULL.";
        PMAnchoringPoint startAnchoring = startPoint.getAnchoring();
        PMAnchoringPoint endAnchoring = endPoint.getAnchoring();
        if (startAnchoring != null && startAnchoring instanceof PMAnchoringPointToFigure) {
            targetFigure3 = ((PMAnchoringPointToFigure)startAnchoring).getFigure();
            assert (targetFigure3 != null) : "targetFigure is NULL.";
            if (parentFigure == targetFigure3) {
                return startAnchoring.getPoint();
            }
        }
        if (endAnchoring != null && endAnchoring instanceof PMAnchoringPointToFigure) {
            targetFigure3 = ((PMAnchoringPointToFigure)endAnchoring).getFigure();
            assert (targetFigure3 != null) : "targetFigure is NULL.";
            if (parentFigure == targetFigure3) {
                return endAnchoring.getPoint();
            }
        }
        if (startAnchoring != null && startAnchoring instanceof PMAnchoringPointToAnchor) {
            PMAnchoringPointToAnchor startAnchoringPTA = (PMAnchoringPointToAnchor)startAnchoring;
            PMAnchor startAnchor = startAnchoringPTA.getAnchor();
            assert (startAnchor != null) : "startAnchor is NULL.";
            PMLine startAnchorLine = startAnchor.getLine();
            assert (startAnchorLine != null) : "startAnchorLine is NULL.";
            targetPlanObject2 = startAnchorLine.getPointList().getPlanObject();
            assert (targetPlanObject2 != null) : "targetPlanObject is NULL.";
            if (targetPlanObject2 instanceof PMFigure && parentFigure == (targetFigure2 = (PMFigure)targetPlanObject2)) {
                return startAnchoring.getPoint();
            }
        }
        if (endAnchoring != null && endAnchoring instanceof PMAnchoringPointToAnchor) {
            PMAnchoringPointToAnchor endAnchoringPTA = (PMAnchoringPointToAnchor)endAnchoring;
            PMAnchor endAnchor = endAnchoringPTA.getAnchor();
            assert (endAnchor != null) : "endAnchor is NULL.";
            PMLine endAnchorLine = endAnchor.getLine();
            assert (endAnchorLine != null) : "endAnchorLine is NULL.";
            targetPlanObject2 = endAnchorLine.getPointList().getPlanObject();
            assert (targetPlanObject2 != null) : "targetPlanObject is NULL.";
            if (targetPlanObject2 instanceof PMFigure && parentFigure.equals(targetFigure2 = (PMFigure)targetPlanObject2)) {
                return endAnchoring.getPoint();
            }
        }
        if (startAnchoring != null && startAnchoring instanceof PMAnchoringPointToLine) {
            PMAnchoringPointToLine startAnchoringPTL = (PMAnchoringPointToLine)startAnchoring;
            PMLine startAnchorLine = startAnchoringPTL.getTargetLine();
            assert (startAnchorLine != null) : "startAnchorLine is NULL.";
            targetPlanObject = startAnchorLine.getPointList().getPlanObject();
            assert (targetPlanObject != null) : "targetPlanObject is NULL.";
            if (targetPlanObject instanceof PMFigure && parentFigure == (targetFigure = (PMFigure)targetPlanObject)) {
                return startAnchoring.getPoint();
            }
        }
        if (endAnchoring != null && endAnchoring instanceof PMAnchoringPointToLine) {
            PMAnchoringPointToLine endAnchoringPTL = (PMAnchoringPointToLine)endAnchoring;
            PMLine endAnchorLine = endAnchoringPTL.getTargetLine();
            assert (endAnchorLine != null) : "endAnchorLine is NULL.";
            targetPlanObject = endAnchorLine.getPointList().getPlanObject();
            assert (targetPlanObject != null) : "targetPlanObject is NULL.";
            if (targetPlanObject instanceof PMFigure && parentFigure == (targetFigure = (PMFigure)targetPlanObject)) {
                return endAnchoring.getPoint();
            }
        }
        if (startAnchoring != null && startAnchoring instanceof PMAnchoringPointToPoint) {
            PMAnchoringPointToPoint startAnchoringPTP = (PMAnchoringPointToPoint)startAnchoring;
            PMPoint startAnchoringPoint = startAnchoringPTP.getTargetPoint();
            assert (startAnchoringPoint != null) : "startAnchoringPoint is NULL.";
            targetPlanObject = startAnchoringPoint.getPointList().getPlanObject();
            assert (targetPlanObject != null) : "targetPlanObject is NULL.";
            if (targetPlanObject instanceof PMFigure && parentFigure == (targetFigure = (PMFigure)targetPlanObject)) {
                return startAnchoring.getPoint();
            }
        }
        if (endAnchoring != null && endAnchoring instanceof PMAnchoringPointToPoint) {
            PMAnchoringPointToPoint endAnchoringPTP = (PMAnchoringPointToPoint)endAnchoring;
            PMPoint endAnchoringPoint = endAnchoringPTP.getTargetPoint();
            assert (endAnchoringPoint != null) : "endAnchoringPoint is NULL.";
            targetPlanObject = endAnchoringPoint.getPointList().getPlanObject();
            assert (targetPlanObject != null) : "targetPlanObject is NULL.";
            if (targetPlanObject instanceof PMFigure && parentFigure == (targetFigure = (PMFigure)targetPlanObject)) {
                assert (startAnchoring != null) : "startAnchoringPoint is NULL.";
                return startAnchoring.getPoint();
            }
        }
        return null;
    }

    private Action createEdgeConversionAction(int relativeActionIndex) {
        ACCreatePlanElement action;
        switch (relativeActionIndex) {
            case 0: {
                IPMPlanRW plan = this.channel.getPlanRW();
                action = this.lastStorageAccessCreationAction = new ACCreatePlanElement(this.getActionContext(), plan, "fmc.bd.storageaccess");
                break;
            }
            case 1: {
                IPMFigureLineShapeRW edgeFigure = (IPMFigureLineShapeRW)this.channel.getFiguresRW("edge").get(0);
                IPMPointListRW pointList = edgeFigure.getPointListRW();
                this.storageAccessPoints = pointList.getPoints();
                this.storageAccessLineForce = new int[pointList.getLineCount()];
                int i = 0;
                while (i < this.storageAccessLineForce.length) {
                    IPMLineRW line = pointList.getLineRW(i);
                    this.storageAccessLineForce[i] = line.getForce();
                    ++i;
                }
                this.storageAccessLineAppearance = edgeFigure.getLineAppearanceRW();
                this.storageAccessStartMarkerAppearance = edgeFigure.getLineStartMarkerAppearanceRW();
                this.storageAccessEndMarkerAppearance = edgeFigure.getLineEndMarkerAppearanceRW();
                action = new ACRemoveFigure(this.getActionContext(), (IPMFigureRW)edgeFigure);
                break;
            }
            case 2: {
                IPMPlanElementFMCBDStorageAccessRW storageAccessPlanElement = (IPMPlanElementFMCBDStorageAccessRW)this.lastStorageAccessCreationAction.getCreatedPlanElement();
                boolean backgroundFigure = false;
                action = new ACCreateFigureLineShape(this.getActionContext(), "outline", (IPMPlanElementRW)storageAccessPlanElement, this.storageAccessPoints, this.storageAccessLineForce, this.storageAccessLineAppearance, this.storageAccessStartMarkerAppearance, this.storageAccessEndMarkerAppearance, backgroundFigure);
                break;
            }
            case 3: {
                IPMPlanElementFMCBDStorageAccessRW storageAccessPlanElement = (IPMPlanElementFMCBDStorageAccessRW)this.lastStorageAccessCreationAction.getCreatedPlanElement();
                IPMPlanRW plan = this.channel.getPlanRW();
                int indexOfChannel = plan.getPlanElementIndex((IPMPlanElementRW)this.channel);
                int indexOfChannelEdge = indexOfChannel + 1;
                action = new ACReorderPlanElementStructure(this.getActionContext(), Collections.singletonList(storageAccessPlanElement), indexOfChannelEdge);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return action;
    }

    public String toString() {
        return "TAMigrateFMCBDChannel ()";
    }
}

