/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.check;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.check.IModelSyntaxChecker;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import com.arcway.planagent.planmodel.check.SyntaxProblem;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDAgentRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDChannelRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDModifyingStorageAccessRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDStorageAccessRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDStorageRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDStructureVarianceRO;
import com.arcway.planagent.planmodel.fmc.bd.check.BDValidityMatrix;
import com.arcway.planagent.planmodel.fmc.bd.check.ProblemBadAccessArcBorderCrossing;
import com.arcway.planagent.planmodel.fmc.bd.check.ProblemBadCombination;
import com.arcway.planagent.planmodel.fmc.bd.check.ProblemBadConnection;
import com.arcway.planagent.planmodel.fmc.bd.check.ProblemBadImplicitAccessArcBorderCrossing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FMCBDModelSyntaxChecker
implements IModelSyntaxChecker {
    public Collection<? extends ISyntaxProblem> checkSyntax(IPMPlanRO plan) {
        ArrayList<ISyntaxProblem> problems = new ArrayList<ISyntaxProblem>();
        int elementNumber = plan.getPlanElementCount();
        int i = 0;
        while (i < elementNumber) {
            IPMPlanElementRO pe = plan.getPlanElementRO(i);
            if (pe instanceof IPMPlanElementFMCBDStorageAccessRO || pe instanceof IPMPlanElementFMCBDModifyingStorageAccessRO) {
                SyntaxProblem prob;
                IPMFigureLineShapeRO fls = null;
                fls = pe instanceof IPMPlanElementFMCBDStorageAccessRO ? ((IPMPlanElementFMCBDStorageAccessRO)pe).getEdgeRO() : ((IPMPlanElementFMCBDModifyingStorageAccessRO)pe).getGeometryLineRO();
                IPMPointRO startPoint = fls.getPointListRO().getPointRO(0);
                IPMPointRO endPoint = fls.getPointListRO().getPointRO(fls.getPointListRO().getPointCount() - 1);
                IPMAnchoringPointRO anchoring1 = startPoint.getAnchoringRO();
                IPMAnchoringPointRO anchoring2 = endPoint.getAnchoringRO();
                IPMFigureRO linkedFigure1 = null;
                IPMFigureRO linkedFigure2 = null;
                IPMPlanElementRO linkedPlanElement1 = null;
                IPMPlanElementRO linkedPlanElement2 = null;
                if (anchoring1 != null) {
                    linkedFigure1 = anchoring1.getAnchoringDestination().getAnchoringFigure();
                    linkedPlanElement1 = linkedFigure1.getPlanElementRO();
                    if (!anchoring1.isDesirable()) {
                        prob = new ProblemBadConnection(pe);
                        prob.addOtherInvolvedElement(linkedPlanElement1);
                        problems.add((ISyntaxProblem)prob);
                    }
                }
                if (anchoring2 != null) {
                    linkedFigure2 = anchoring2.getAnchoringDestination().getAnchoringFigure();
                    linkedPlanElement2 = linkedFigure2.getPlanElementRO();
                    if (!anchoring2.isDesirable()) {
                        prob = new ProblemBadConnection(pe);
                        prob.addOtherInvolvedElement(linkedPlanElement2);
                        problems.add((ISyntaxProblem)prob);
                    }
                }
                if (linkedFigure1 != null && linkedFigure2 != null) {
                    if (!BDValidityMatrix.isCombinationValid(linkedFigure1, linkedFigure2)) {
                        prob = new ProblemBadCombination(pe);
                        prob.addOtherInvolvedElement(linkedPlanElement1);
                        prob.addOtherInvolvedElement(linkedPlanElement2);
                        problems.add((ISyntaxProblem)prob);
                    }
                    this.checkBadBorderCrossing(pe, linkedPlanElement1, linkedPlanElement2, problems, true);
                    this.checkBadBorderCrossing(pe, linkedPlanElement2, linkedPlanElement1, problems, true);
                }
            }
            ++i;
        }
        return problems;
    }

    private void checkBadBorderCrossing(IPMPlanElementRO pe, IPMPlanElementRO linking, IPMPlanElementRO linked, List<ISyntaxProblem> problemList, boolean direct) {
        if (linking instanceof IPMPlanElementFMCBDStructureVarianceRO || linked instanceof IPMPlanElementFMCBDStructureVarianceRO) {
            return;
        }
        Set linkedElementContainers = linked.getAllContainersRO();
        for (IPMPlanElementRO containedElement : linking.getAllContainedRO()) {
            if (containedElement == linking || FMCBDModelSyntaxChecker.isEqualType(containedElement, linked)) continue;
            this.checkBadBorderCrossing(pe, containedElement, linked, problemList, false);
        }
        for (IPMPlanElementRO container : linking.getAllContainersRO()) {
            boolean isDangerouslyContained = false;
            if (linking instanceof IPMPlanElementFMCBDAgentRO && (container instanceof IPMPlanElementFMCBDStorageRO || container instanceof IPMPlanElementFMCBDChannelRO)) {
                isDangerouslyContained = true;
            }
            if ((linking instanceof IPMPlanElementFMCBDStorageRO || linking instanceof IPMPlanElementFMCBDChannelRO) && container instanceof IPMPlanElementFMCBDAgentRO) {
                isDangerouslyContained = true;
            }
            if (!isDangerouslyContained || linkedElementContainers.contains(container)) continue;
            SyntaxProblem prob = direct ? new ProblemBadAccessArcBorderCrossing(pe) : new ProblemBadImplicitAccessArcBorderCrossing(pe);
            prob.addOtherInvolvedElement(linking);
            prob.addOtherInvolvedElement(linked);
            prob.addOtherInvolvedElement(container);
            problemList.add((ISyntaxProblem)prob);
            return;
        }
    }

    private static boolean isEqualType(IPMPlanElementRO first, IPMPlanElementRO second) {
        boolean equal = false;
        if (first instanceof IPMPlanElementFMCBDAgentRO) {
            equal = second instanceof IPMPlanElementFMCBDAgentRO;
        } else if (first instanceof IPMPlanElementFMCBDChannelRO || first instanceof IPMPlanElementFMCBDStorageRO) {
            equal = second instanceof IPMPlanElementFMCBDChannelRO || second instanceof IPMPlanElementFMCBDStorageRO;
        }
        return equal;
    }

    public String[] getCheckablePlanTypes() {
        return new String[]{"fmc.bd"};
    }
}

