/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithStickmanSupplementRO;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithStickmanSupplementRW;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementStickman;
import com.arcway.planagent.planmodel.cm.appearance.IStickmanAppearanceRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateStickmanSupplement
extends PredeterminedLengthTransaction {
    private static final int STEPS = 1;
    private Points stickmanPoints;
    private int[] stickmanForce;
    private IStickmanAppearanceRO stickmanAppearance;
    private final IPMFigureRW agentFigure;
    private final String stickmanRole;

    public TACreateStickmanSupplement(IPMPlanElementWithStickmanSupplementRO agent, ActionParameters actionParameters, Points stickmanPoints, IStickmanAppearanceRO stickmanAppearance) {
        super(1, (IPMPlanModelObjectRW)agent, actionParameters);
        assert (stickmanAppearance != null) : "stickmanAppearance is null";
        this.transactionAssertion(stickmanPoints.size() == 4, "number of points describing stickman figure != 4");
        this.agentFigure = ((IPMPlanElementWithStickmanSupplementRW)((Object)agent)).getFigureForStickman();
        this.stickmanRole = ((IPMPlanElementWithStickmanSupplementRW)((Object)agent)).getStickmanRole();
        try {
            this.stickmanPoints = stickmanPoints;
            this.stickmanForce = LineHelper.createAlternatingLineForcesClosed(stickmanPoints);
            this.stickmanAppearance = stickmanAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createStickmanAction();
            }
        }
        return null;
    }

    private Action createStickmanAction() {
        return new ACCreateGraphicalSupplementStickman(this.getActionContext(), this.stickmanPoints, this.stickmanForce, this.agentFigure, this.stickmanRole, this.stickmanAppearance);
    }

    public String toString() {
        return "TAAddFMCBDStickman (Points " + this.stickmanPoints + ")";
    }
}

