/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.reactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithNameSupplementRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.reactions.IRASetPlanElementName;

public class RAFixFMCBDNameSupplementAfterPlanElementNameChange
implements IRASetPlanElementName {
    private static final ILogger logger = Logger.getLogger(RAFixFMCBDNameSupplementAfterPlanElementNameChange.class);

    private boolean needsToSetText(String name, String oldText) {
        return !StringUtil.removeLineBreaksAndControlCharacters((String)oldText).trim().equals(name);
    }

    public ActionIterator createReactionsPlanElementNameSet(IPMPlanElementRW planElement, String newName, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RIFixNameSupplementAfterPlanElementNameChangeAgent createReactions(" + planElement + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(1);
        if (planElement instanceof IPMPlanElementWithNameSupplementRW) {
            IPMPlanElementWithNameSupplementRW planElementWithNameSupplement = (IPMPlanElementWithNameSupplementRW)planElement;
            String name = String.valueOf(planElementWithNameSupplement.getNamePrefix()) + planElementWithNameSupplement.getName() + planElementWithNameSupplement.getNamePostfix();
            IPMGraphicalSupplementTextRW nameSupplement = planElementWithNameSupplement.getNameSupplementRW();
            if (nameSupplement != null && this.needsToSetText(name, nameSupplement.getText())) {
                actions.addAction((Action)new ACSetTextGraphicalSupplementText(context, nameSupplement, name));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("createReactions(IPMPlanElementRW, String, ActionContext) - end - return value = " + actions);
        }
        return actions;
    }
}

