/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCStorageRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateBPREEPCStorage
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private static final double MINIMAL_CORNER_RADIUS = 3.0;
    private Points storagePoints;
    private int[] storageForce;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fillAppearance;
    private IPMPlanElementBPREEPCStorageRO createdStorage;

    public TACreateBPREEPCStorage(IPMPlanRO plan, ActionParameters actionParameters, Points storagePoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "ILineAppearance is null";
        this.transactionAssertion(storagePoints.size() >= 4, "not enough points describing storage figure");
        this.transactionAssertion(lineAppearance.getCornerRadius() > 3.0, "the storage's corner radius is too small");
        try {
            this.storagePoints = storagePoints;
            this.storageForce = LineHelper.createAlternatingLineForcesClosed((Points)storagePoints);
            this.lineAppearance = lineAppearance;
            this.fillAppearance = fillAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createStorageAction();
            }
            case 1: {
                this.createdStorage = (IPMPlanElementBPREEPCStorageRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return null;
    }

    private Action createStorageAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "bpre.epc.storage");
    }

    private Action createOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "outline", previousAction.getCreatedPlanElement(), this.storagePoints, this.storageForce, this.lineAppearance, this.fillAppearance, false);
    }

    public IPMPlanElementBPREEPCStorageRO getCreatedStorage() {
        return this.createdStorage;
    }

    public String toString() {
        return "TACreateBPREEPCStorage (Points " + this.storagePoints + ")";
    }
}

