/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.bpre.epc.access.readwrite.IPMGraphicalSupplementBPREEPCLogicalOperatorSymbolRW;
import com.arcway.planagent.planmodel.bpre.epc.access.readwrite.IPMPlanElementBPREEPCLogicalOperatorRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAFixLogicalOperatorGraphicalSupplement
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAFixLogicalOperatorGraphicalSupplement.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6);
        this.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMPlanElementRW planElement = figure.getPlanElementRW();
        if (!(planElement instanceof IPMPlanElementBPREEPCLogicalOperatorRW)) {
            return;
        }
        IPMPlanElementBPREEPCLogicalOperatorRW logicalOperator = (IPMPlanElementBPREEPCLogicalOperatorRW)planElement;
        IPMGraphicalSupplementBPREEPCLogicalOperatorSymbolRW supplement = logicalOperator.getSymbolRW();
        if (supplement == null) {
            return;
        }
        assert (supplement.getPointListRW().getLineCount() == 4);
        IPMPointRW upperLeftSupplement = null;
        IPMPointRW lowerRightSupplement = null;
        int i = 0;
        while (i < supplement.getPointListRW().getPointCount()) {
            IPMPointRW currentPoint = supplement.getPointListRW().getPointRW(i);
            if (upperLeftSupplement == null) {
                upperLeftSupplement = currentPoint;
            } else if (currentPoint.getPosition().y + 1.0E-10 < upperLeftSupplement.getPosition().y) {
                upperLeftSupplement = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)upperLeftSupplement.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < upperLeftSupplement.getPosition().x) {
                upperLeftSupplement = currentPoint;
            }
            if (lowerRightSupplement == null) {
                lowerRightSupplement = currentPoint;
            } else if (currentPoint.getPosition().y - 1.0E-10 > lowerRightSupplement.getPosition().y) {
                lowerRightSupplement = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lowerRightSupplement.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lowerRightSupplement.getPosition().x) {
                lowerRightSupplement = currentPoint;
            }
            ++i;
        }
        IPMFigurePlaneRW outline = logicalOperator.getOutlineFigurePlaneRW();
        if (outline == null) {
            return;
        }
        IPMPointRW upperLeftOutline = null;
        IPMPointRW lowerRightOutline = null;
        int i2 = 0;
        while (i2 < outline.getPointListRW().getPointCount()) {
            IPMPointRW currentPoint = outline.getPointListRW().getPointRW(i2);
            if (upperLeftOutline == null) {
                upperLeftOutline = currentPoint;
            } else if (currentPoint.getPosition().y + 1.0E-10 < upperLeftOutline.getPosition().y) {
                upperLeftOutline = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)upperLeftOutline.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < upperLeftOutline.getPosition().x) {
                upperLeftOutline = currentPoint;
            }
            if (lowerRightOutline == null) {
                lowerRightOutline = currentPoint;
            } else if (currentPoint.getPosition().y - 1.0E-10 > lowerRightOutline.getPosition().y) {
                lowerRightOutline = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lowerRightOutline.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lowerRightOutline.getPosition().x) {
                lowerRightOutline = currentPoint;
            }
            ++i2;
        }
        assert (lowerRightSupplement != null) : "lr is NULL.";
        assert (upperLeftSupplement != null) : "ul is NULL.";
        assert (lowerRightOutline != null) : "lr is NULL.";
        assert (upperLeftOutline != null) : "ul is NULL.";
        ACMovePoint moveUl = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)upperLeftSupplement, (GeoVector)new GeoVector(upperLeftSupplement.getPosition(), upperLeftOutline.getPosition()), (boolean)false);
        actions.addAction((Action)moveUl);
        ACMovePoint moveLr = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lowerRightSupplement, (GeoVector)new GeoVector(lowerRightSupplement.getPosition(), lowerRightOutline.getPosition()), (boolean)false);
        actions.addAction((Action)moveLr);
    }
}

