/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.persistent;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.bpre.epc.appearance.BPREEPCXORSymbolAppearance;
import com.arcway.planagent.planmodel.bpre.epc.appearance.IBPREEPCXORSymbolAppearance;
import com.arcway.planagent.planmodel.persistent.EATextAppearance;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EAXORSymbolBPREEPCAppearance
extends EAEncodableAttributes
implements IBPREEPCXORSymbolAppearance {
    private static final ILogger logger = Logger.getLogger(EAXORSymbolBPREEPCAppearance.class);
    private static final String ATTR_TAG_COLOR_RED = "color.red";
    private static final String ATTR_TAG_COLOR_GREEN = "color.green";
    private static final String ATTR_TAG_COLOR_BLUE = "color.blue";
    private static final String ATTR_TAG_COLOR_TRANSPARENT = "color.transparent";
    private Color color = new Color(0, 0, 0);
    private final EATextAppearance textAppearance = new EATextAppearance("text");

    public EAXORSymbolBPREEPCAppearance(String attrTagPrefix) {
        super(attrTagPrefix);
    }

    public EAXORSymbolBPREEPCAppearance(EAEncodableAttributes ea, String attrTagPrefix) {
        super(ea, attrTagPrefix);
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "appendAttributesToXML(OutputStream outp = " + writeContext + ") - start");
        }
        assert (writeContext != null) : "outp is NULL.";
        if (this.color.transparent) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_TRANSPARENT, this.color.transparent);
        }
        if (!(this.color.r == 0 && this.color.g == 0 && this.color.b == 0 || this.color.transparent)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_RED, this.color.r);
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_GREEN, this.color.g);
            this.appendAttrToXML(writeContext, ATTR_TAG_COLOR_BLUE, this.color.b);
        }
        this.textAppearance.appendAttributesToXML(writeContext);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "appendAttributesToXML(OutputStream) - end");
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSubAttributeFromXML(String name = " + name + ", String value = " + value + ") - start");
        }
        boolean knownAttribute = this.textAppearance.setAttributeFromXML(name, value);
        if (ATTR_TAG_COLOR_RED.equals(name)) {
            this.color.r = this.toInt(value);
        } else if (ATTR_TAG_COLOR_GREEN.equals(name)) {
            this.color.g = this.toInt(value);
        } else if (ATTR_TAG_COLOR_BLUE.equals(name)) {
            this.color.b = this.toInt(value);
        } else if (ATTR_TAG_COLOR_TRANSPARENT.equals(name)) {
            this.color.transparent = this.toBoolean(value);
        } else {
            knownAttribute = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setSubAttributeFromXML(String, String) - end - return value = " + knownAttribute);
        }
        return knownAttribute;
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IBPREEPCXORSymbolAppearance)) {
            return;
        }
        IBPREEPCXORSymbolAppearance orSymbol = (IBPREEPCXORSymbolAppearance)appearance;
        this.setTextAppearance((ITextAppearanceRO)new TextAppearance(orSymbol.getTextAppearanceRO()));
        this.setColor(orSymbol.getColor());
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new BPREEPCXORSymbolAppearance(this);
    }

    @Override
    public void setColor(Color color) {
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setColor(Color color = " + color + ") - start");
        }
        assert (color != null) : "color is NULL.";
        this.color = new Color(color);
        if (logger.isDebugEnabled()) {
            logger.debug(51, "setColor(Color) - end");
        }
    }

    @Override
    public Color getColor() {
        return new Color(this.color);
    }

    @Override
    public void setTextAppearance(ITextAppearanceRO textAppearance) {
        TextAppearance.copy((ITextAppearanceRO)textAppearance, (ITextAppearance)this.textAppearance);
    }

    @Override
    public ITextAppearanceRO getTextAppearanceRO() {
        return this.textAppearance;
    }

    public ITextAppearance getTextAppearance() {
        return (ITextAppearance)this.getTextAppearanceRO();
    }
}

