/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCEventRO;
import com.arcway.planagent.planmodel.bpre.epc.check.BPREEPCValidityMatrix;
import com.arcway.planagent.planmodel.bpre.epc.relations.BPREEPCRelationMatrix;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouter;
import com.arcway.planagent.planmodel.cm.routing.ElongationToFigureCenterRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;

public class PMPlanBPREEPC
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "bpre.epc";
    private static String XML_TYPE = "bpre.epc";

    public PMPlanBPREEPC(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public PMPlanBPREEPC(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return new String[]{"bpre.epc.controlflow", "bpre.epc.event", "bpre.epc.function", "bpre.epc.storage", "bpre.epc.competency", "bpre.epc.and", "bpre.epc.or", "bpre.epc.xor", "bpre.epc.informationflow", "bpre.epc.document", "bpre.epc.organisationunit", "bpre.epc.organisationunitassignment", "bpre.epc.supportingsystem", "fmc.cm.lineshapecomment", "fmc.cm.planecomment", "fmc.cm.dotscomment", "fmc.cm.legend"};
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = false;
        IPMFigureRO fig1 = source.getAnchoringFigure();
        IPMFigureRO fig2 = destination.getAnchoringFigure();
        return isDesirable |= BPREEPCValidityMatrix.isTouchValid(fig1, fig2);
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= BPREEPCValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= BPREEPCValidityMatrix.isPointToPointAnchoringPossible();
            }
        }
        return isAllowed;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router;
        if (anchoring instanceof IAnchoringPoint2Figure) {
            IPMPointRO sourcePoint;
            IPMPointListRO sourcePointList;
            IAnchoringPoint2Figure anchoringPoint2Figure;
            IAnchoringSourcePoint anchoringSourcePoint;
            boolean toCenterRouter = false;
            if (anchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO() instanceof IPMPlanElementBPREEPCEventRO && (anchoringSourcePoint = (anchoringPoint2Figure = (IAnchoringPoint2Figure)anchoring).getAnchoringSourcePoint()) instanceof IPMPointRO && (sourcePointList = (sourcePoint = (IPMPointRO)anchoringSourcePoint).getPointListRO()).getPointCount() >= 2) {
                IPMPointRO startPoint = sourcePointList.getPointRO(0);
                IPMPointRO endPoint = sourcePointList.getPointRO(sourcePointList.getPointCount() - 1);
                IPMLineRO line = null;
                if (sourcePoint == startPoint) {
                    line = startPoint.getLine2ndRO();
                } else if (sourcePoint == endPoint) {
                    line = endPoint.getLine1stRO();
                }
                if (line != null && line.getForce() == 1) {
                    toCenterRouter = true;
                }
            }
            router = toCenterRouter ? new ElongationToFigureCenterRouter() : new CurveLineRouter();
        } else {
            router = anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : new RemoveAnchoringRouter();
        }
        return router;
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        return false;
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        int direction = BPREEPCRelationMatrix.getDirection((ILineMarkerAppearanceRO)lineStartMarkerAppearanceRO, (ILineMarkerAppearanceRO)lineEndMarkerAppearanceRO);
        if (direction != -1) {
            if (BPREEPCRelationMatrix.isCausality(startPlanElementType, endElementType)) {
                return new PlanElementRelation(1, direction);
            }
            if (BPREEPCRelationMatrix.isAccess(startPlanElementType, endElementType)) {
                return new PlanElementRelation(0, direction);
            }
        }
        return null;
    }

    public FlowType getFlowType() {
        return FlowType.VERTICAL;
    }
}

