/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.acm.pd.implementation;

import com.arcway.lib.geometry.Point;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.acm.pd.access.readonly.IPMPlanElementACMPDProcessStepRO;
import com.arcway.planagent.planmodel.acm.pd.access.readwrite.IPMPlanElementACMPDProcessStepRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.transactions.ForceValidPointsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementACMPDProcessStep
extends PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementACMPDProcessStepRO,
IPMPlanElementACMPDProcessStepRW {
    public static final String XML_FIGURE_ARROW_ROLE = "arrow";
    public static final String XML_FIGURE_GEOMETRYFIGURE_ROLE = "geometryFigure";
    public static final String XML_TYPE = "acm.pd.processstep";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";

    @Deprecated
    public PMPlanElementACMPDProcessStep(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    @Deprecated
    public PMPlanElementACMPDProcessStep(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    public TopologyType getToplogyType() {
        return TopologyType.DEEP;
    }

    @Override
    public IPMFigurePlaneRO getArrowFigureRO() {
        return this.getArrowFigure();
    }

    @Override
    public IPMFigurePlaneRW getArrowFigureRW() {
        return this.getArrowFigure();
    }

    public Collection<IPMFigureRO> getEditFigures() {
        return Collections.singleton(this.getGeometryFigure());
    }

    @Override
    public IPMFigurePlaneRO getGeometryFigureRO() {
        return (IPMFigurePlaneRO)this.getGeometryFigure();
    }

    @Override
    public IPMFigurePlaneRW getGeometryFigureRW() {
        return (IPMFigurePlaneRW)this.getGeometryFigure();
    }

    public PMFigure getOutlineFigure() {
        return (PMFigure)this.getGeometryFigure();
    }

    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null);
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW()));
        return super.getResizeSupplementRouter(graphSuppl);
    }

    public ITransactionValidator getTransactionValidator() {
        return new ForceValidPointsTransactionValidator((IPMPlanElementRO)this, new Point(7.5, 0.0));
    }

    private PMFigurePlane getArrowFigure() {
        List figures = this.getFiguresRO(XML_FIGURE_ARROW_ROLE);
        if (figures.size() == 0) {
            return null;
        }
        assert (figures.get(0) instanceof PMFigurePlane);
        assert (figures.size() == 1) : "more than one arrow found";
        return (PMFigurePlane)figures.get(0);
    }

    private IPMFigureRO getGeometryFigure() {
        List figures = this.getFiguresRO(XML_FIGURE_GEOMETRYFIGURE_ROLE);
        if (figures.size() == 0) {
            return null;
        }
        assert (figures.get(0) instanceof PMFigurePlane);
        assert (figures.size() == 1);
        return (IPMFigureRO)figures.get(0);
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getOutlineFigureRW();
    }

    public PMGraphicalSupplementText getNameSupplement() {
        PMGraphicalSupplementText supplement = null;
        IPMFigureRO geometryFigure = this.getGeometryFigure();
        ArrayList textSupplements = geometryFigure == null ? new ArrayList(1) : geometryFigure.getGraphicalSupplements("nameSupplement");
        PMFigurePlane arrowFigure = this.getArrowFigure();
        if (arrowFigure != null) {
            textSupplements.addAll(arrowFigure.getGraphicalSupplements("nameSupplement"));
        }
        if (textSupplements.size() == 1) {
            supplement = (PMGraphicalSupplementText)textSupplements.get(0);
        }
        return supplement;
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = this.getOutlineFigure();
        assert (outlineFigure != null);
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        assert (supplementRefs != null);
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1);
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    public boolean isHighlightableFigure(PMFigure figureToCheck) {
        boolean isArrowFigure = figureToCheck.getRole().equals(XML_FIGURE_ARROW_ROLE);
        return isArrowFigure && super.isHighlightableFigure(figureToCheck);
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }
}

