/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planimporterexporter.bpre.epc;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planimporterexporter.plangeneration.AbstractPlanElementGenerator;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithNameSupplementRO;
import com.arcway.planagent.planmodel.base.transactions.TACreateNameSupplement;
import com.arcway.planagent.planmodel.base.transactions.TASetPlanElementNameSupplement;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCEventRO;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCEvent;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class EPCPlanElementGeneratorEvent
extends AbstractPlanElementGenerator {
    private final Points txtPts = new Points();
    private final LineAppearance lineAppearance = new LineAppearance();
    private final FillAppearance fillAppearance = new FillAppearance();
    private final Point pt1;
    private final Point pt2;
    private final Point pt3;
    private final Point pt4;
    private final Rectangle r;
    private final String name;

    public EPCPlanElementGeneratorEvent(String name, double startX, double endX, double startY, double endY) {
        this.name = name;
        this.pt1 = new Point(startX, startY);
        this.pt2 = new Point(endX, startY);
        this.pt3 = new Point(endX, endY);
        this.pt4 = new Point(startX, endY);
        this.r = new Rectangle(this.pt1, this.pt3);
        this.txtPts.add(this.pt1);
        this.txtPts.add(this.pt2);
        this.txtPts.add(this.pt3);
        this.txtPts.add(this.pt4);
        this.lineAppearance.setLineColor(Color.BLACK);
        this.lineAppearance.setLineStyle(LineStyle.SOLID);
        this.lineAppearance.setLineThickness(0.5);
        this.fillAppearance.setFillStyle(FillStyle.SOLID);
        this.fillAppearance.setFillColor(new FillColor(255, 232, 232));
    }

    public IPMPlanElementRO generatePlanElement(IPMPlanRO plan) {
        TACreateBPREEPCEvent transaction = new TACreateBPREEPCEvent(plan, ActionParameters.DUMMY, this.r, (ILineAppearanceRO)this.lineAppearance, (IFillAppearanceRO)this.fillAppearance);
        this.executeTransaction((Transaction)transaction);
        IPMPlanElementBPREEPCEventRO planElement = transaction.getCreatedEvent();
        IPMFigurePlaneRO geometryFigure = planElement.getGeometryFigureRO();
        TACreateNameSupplement addNameSupplementTransaction = new TACreateNameSupplement((IPMPlanElementWithNameSupplementRO)planElement, (IPMFigureRO)geometryFigure, ActionParameters.DUMMY, this.getTextAppearance(), this.txtPts);
        this.executeTransaction((Transaction)addNameSupplementTransaction);
        TASetPlanElementNameSupplement setNameSupplementTransaction = new TASetPlanElementNameSupplement((IPMPlanElementWithNameSupplementRO)planElement, ActionParameters.DUMMY, this.name);
        this.executeTransaction((Transaction)setNameSupplementTransaction);
        return planElement;
    }
}

