/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planeditor.handles.EXDontKnowHowToFixException;
import com.arcway.planagent.planeditor.handles.PVHandleView;
import com.arcway.planagent.planeditor.handles.TransformingHandleLocator;

public class PVHandleViewColoredRectangle
extends PVHandleView {
    public static final double DEFAULT_HANDLE_WIDTH = 8.0;
    public static final double DEFAULT_HANDLE_HEIGHT = 8.0;
    private double borderWidth;
    private Color borderColor;
    private LineStyle borderStyle;
    private FillColor fillColor;
    private FillStyle fillStyle;
    private double width;
    private double height;

    protected PVHandleViewColoredRectangle(TransformingHandleLocator locator, double width, double height, double borderWidth, Color borderColor, LineStyle borderStyle, FillColor fillColor, FillStyle fillStyle) {
        super(locator);
        this.setWidth(width);
        this.setHeight(height);
        this.setBorderWidth(borderWidth);
        this.setBorderColor(borderColor);
        this.setBorderStyle(borderStyle);
        this.setFillColor(fillColor);
        this.setFillStyle(fillStyle);
    }

    protected Color getBorderColor() {
        return new Color(this.borderColor);
    }

    protected FillColor getFillColor() {
        return this.fillColor;
    }

    public void setBorderColor(Color color) {
        assert (color != null) : "color is null";
        this.borderColor = color;
    }

    public void setFillColor(FillColor color) {
        assert (color != null) : "color is null";
        this.fillColor = new FillColor(color);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public LineStyle getBorderStyle() {
        return this.borderStyle;
    }

    public double getBorderWidth() {
        return this.borderWidth;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setBorderStyle(LineStyle style) {
        this.borderStyle = style;
    }

    public void setBorderWidth(double lineWidth) {
        this.borderWidth = lineWidth;
    }

    public void setFillStyle(FillStyle style) {
        this.fillStyle = style;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void drawFigure(Device device) {
        Points referencePoints = this.getReferencePoints();
        if (referencePoints.size() < 1) {
            throw new EXDontKnowHowToFixException("Try to draw uninitialized colored rectangle handle.");
        }
        Point referencePoint = referencePoints.get(0);
        Dimension d = new Dimension(this.getWidth(), this.getHeight());
        Rectangle r = new Rectangle(referencePoint, d);
        Corners corners = new Corners();
        corners.add((Point)new Corner(r.upperLeft.x, r.upperLeft.y, 0.0));
        corners.add((Point)new Corner(r.lowerRight.x, r.upperLeft.y, 0.0));
        corners.add((Point)new Corner(r.lowerRight.x, r.lowerRight.y, 0.0));
        corners.add((Point)new Corner(r.upperLeft.x, r.lowerRight.y, 0.0));
        device.polygon(corners, this.getFillColor(), this.getFillStyle(), this.getBorderWidth(), this.getBorderColor(), this.getBorderStyle());
    }
}

