/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.handles.HandlePointCreatePlanElementStructure;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithOutline;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import java.util.ArrayList;
import java.util.List;

public class HandleBar {
    public static final int RIGHT_SIDE = 0;
    public static final int UPPER_SIDE = 90;
    public static final int LEFT_SIDE = 180;
    public static final int LOWER_SIDE = 270;
    private static final int GAP_BETWEEN_HANDLES_AND_PLANELEMENT_IN_PIXELS = 16;
    private static final int DISTANCE_BETWEEN_HANDLES_IN_PIXELS = 6;
    private static final int HANDLE_WIDTH_IN_PIXELS = 18;
    private final List<HandlePointCreatePlanElementStructure> unpositionedHandles = new ArrayList<HandlePointCreatePlanElementStructure>();
    private Rectangle outerBounds = null;
    private int direction = 0;

    public HandleBar(PEPlanElement pePlanElement, int direction) {
        assert (direction == 0 || direction == 90 || direction == 180 || direction == 270) : "dir doesn't match a discrete direction (0, 90, 180, 270)";
        PMPlanElement pmPlanElement = pePlanElement.getPMPlanElement();
        if (pmPlanElement instanceof PMPlanElementWithOutline) {
            PMPlanElementWithOutline planElementWithOutline = (PMPlanElementWithOutline)pmPlanElement;
            PMFigure outlineFigure = (PMFigure)planElementWithOutline.getOutlineFigure();
            this.outerBounds = outlineFigure.getPointUnionWithoutChildren();
        } else {
            this.outerBounds = pmPlanElement.calculatePointUnion();
        }
        assert (this.outerBounds != null) : "couldn't compute outer bounds of given plan element";
        this.direction = direction;
    }

    public void addHandle(HandlePointCreatePlanElementStructure handle) {
        this.unpositionedHandles.add(handle);
    }

    public List<HandlePointCreatePlanElementStructure> calculatePositionedHandles() {
        GeoVector vector;
        GeoVector offsetInPixels;
        Point handlePositionInPlanCoordintats;
        Point center = this.outerBounds.center();
        Point lowerRight = this.outerBounds.lowerRight;
        Point upperLeft = this.outerBounds.upperLeft;
        if (this.direction == 0) {
            handlePositionInPlanCoordintats = new Point(lowerRight.x, center.y);
            offsetInPixels = new GeoVector(16.0, 0.0);
        } else if (this.direction == 90) {
            handlePositionInPlanCoordintats = new Point(center.x, upperLeft.y);
            offsetInPixels = new GeoVector(0.0, -16.0);
        } else if (this.direction == 180) {
            handlePositionInPlanCoordintats = new Point(upperLeft.x, center.y);
            offsetInPixels = new GeoVector(-16.0, 0.0);
        } else if (this.direction == 270) {
            handlePositionInPlanCoordintats = new Point(center.x, lowerRight.y);
            offsetInPixels = new GeoVector(0.0, 16.0);
        } else {
            throw new IllegalArgumentException();
        }
        int numberOfHandles = this.unpositionedHandles.size();
        int barWidth = 18 * numberOfHandles + 6 * (numberOfHandles - 1);
        if (this.direction == 0 || this.direction == 180) {
            vector = new GeoVector(24.0, Direction.ANGLE_270);
            offsetInPixels = GeoVector.add((GeoVector)offsetInPixels, (GeoVector)new GeoVector(0.0, (double)(-(barWidth / 2 - 9))));
        } else {
            vector = new GeoVector(24.0, Direction.ANGLE_0);
            offsetInPixels = GeoVector.add((GeoVector)offsetInPixels, (GeoVector)new GeoVector((double)(-(barWidth / 2 - 9)), 0.0));
        }
        for (HandlePointCreatePlanElementStructure handle : this.unpositionedHandles) {
            handle.setPosition(handlePositionInPlanCoordintats, offsetInPixels);
            handle.setDirection(Direction.valueOf((double)this.direction));
            offsetInPixels = GeoVector.add((GeoVector)offsetInPixels, (GeoVector)vector);
        }
        return this.unpositionedHandles;
    }
}

