/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.figures;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;

public class FigureTransformation
extends Transformation {
    private final IFigure sourceReference;
    private final IFigure destinationReference;
    private final boolean sourceCoordinatesInClientArea;
    private final boolean destinationCoordinatesInClientArea;
    private final Transformation inverseTransformation;

    public FigureTransformation(IFigure sourceReference, boolean sourceCoordinatesInClientArea, IFigure destinationReference, boolean destinationCoordinatesInClientArea) {
        this.sourceReference = sourceReference;
        this.sourceCoordinatesInClientArea = sourceCoordinatesInClientArea;
        this.destinationReference = destinationReference;
        this.destinationCoordinatesInClientArea = destinationCoordinatesInClientArea;
        this.inverseTransformation = new FigureTransformation(this);
    }

    private FigureTransformation(FigureTransformation inverseTransformation) {
        this.sourceReference = inverseTransformation.destinationReference;
        this.sourceCoordinatesInClientArea = inverseTransformation.destinationCoordinatesInClientArea;
        this.destinationReference = inverseTransformation.sourceReference;
        this.destinationCoordinatesInClientArea = inverseTransformation.sourceCoordinatesInClientArea;
        this.inverseTransformation = inverseTransformation;
    }

    public boolean isNOPTransformation() {
        return false;
    }

    public Transformation getInverse() {
        return this.inverseTransformation;
    }

    public Transformation getCopy() {
        return new FigureTransformation(this.sourceReference, this.sourceCoordinatesInClientArea, this.destinationReference, this.destinationCoordinatesInClientArea);
    }

    protected Point transform(Point p) {
        PrecisionPoint pointToTransform = new PrecisionPoint(p.x, p.y);
        FigureTransformation.translateToAbsolute((Translatable)pointToTransform, this.sourceReference, this.sourceCoordinatesInClientArea);
        FigureTransformation.translateToRelative((Translatable)pointToTransform, this.destinationReference, this.destinationCoordinatesInClientArea);
        return new Point(pointToTransform.preciseX(), pointToTransform.preciseY());
    }

    private static void translateToAbsolute(Translatable t, IFigure referenceFigure, boolean coordinatesInClientArea) {
        if (coordinatesInClientArea) {
            referenceFigure.translateToParent(t);
        }
        referenceFigure.translateToAbsolute(t);
    }

    private static void translateToRelative(Translatable t, IFigure referenceFigure, boolean coordinatesInClientArea) {
        referenceFigure.translateToRelative(t);
        if (coordinatesInClientArea) {
            referenceFigure.translateFromParent(t);
        }
    }

    public boolean isEqualTransformation(Transformation other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof FigureTransformation) {
            FigureTransformation o = (FigureTransformation)other;
            if (this.sourceReference != o.sourceReference) {
                return false;
            }
            if (this.destinationReference != o.destinationReference) {
                return false;
            }
            if (this.sourceCoordinatesInClientArea != o.sourceCoordinatesInClientArea) {
                return false;
            }
            return this.destinationCoordinatesInClientArea == o.destinationCoordinatesInClientArea;
        }
        return false;
    }
}

