/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.planeditor.IHelpContextIDs;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.dialogs.AbstractPreviewDialogSettings;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialog;
import com.arcway.planagent.planeditor.dialogs.AbstractSaveAsDialogSettings;
import com.arcway.planagent.planeditor.dialogs.DoublePattern;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsPNGDialogSettings;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import de.plans.lib.util.LocalisationUtils;
import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SaveAsPNGDialog
extends AbstractSaveAsDialog {
    private static final String TITLE = Messages.getString("SaveAsImageDialog.Image_setup");
    private static final String MESSAGE = Messages.getString("SaveAsImageDialog.Configure_the_settings_for_the_target_image");
    private static final int ITEM_BOTH_DIMENSIONS = 13;
    private static final int ITEM_HEIGHT = 14;
    private static final int ITEM_WIDTH = 15;
    private static final int ITEM_RESOLUTION2 = 16;
    private static final int ITEM_RESOLUTION = 17;
    private static final int ITEM_SIZE = 18;
    protected static final int NR_OF_IMAGE_ITEMS = 20;
    private static final String WARNING_IMAGE_SIZE1 = Messages.getString("SaveAsImageDialog.Caution__The_created_image_will_need_around");
    private static final String WARNING_IMAGE_SIZE2 = Messages.getString("SaveAsImageDialog.MB_in_size");
    private static final String ERROR_IMAGE_SIZE1 = Messages.getString("SaveAsImageDialog.Error__The_created_image_will_need_around");
    private static final String ERROR_IMAGE_SIZE2 = Messages.getString("SaveAsImageDialog.Error_MB_in_size");
    private static final int THRESHOLD_SIZE_IN_BYTE = 8000000;
    private static final double THRESHOLD_FREEMEM_MAXSIZE_RATIO = 2.1;
    private static final String GROUP_NAME = Messages.getString("SaveAsImageDialog.Dimensions_and_Resolution");
    private static final String PIXELS_LABEL_DPI = Messages.getString("SaveAsImageDialog.Resolution_(dpi)");
    private static final String[] PIXELS_ITEMS_DPI = new String[]{"600", "300", "150", "96", "75", "30"};
    private static final String HEIGHT_LABEL1 = Messages.getString("SaveAsImageDialog.Fixed_height");
    private static final String HEIGHT_LABEL2 = Messages.getString("SaveAsImageDialog.pixels_vertically");
    private static final String WIDTH_LABEL1 = Messages.getString("SaveAsImageDialog.Fixed_width");
    private static final String WIDTH_LABEL2 = Messages.getString("SaveAsImageDialog.pixels_horizontally");
    private static final String DIMENSIONS_LABEL = Messages.getString("SaveAsImageDialog.Fixed_height_and_width");
    private static final String[] DIMENSIONS_ITEMS = new String[]{"100", "200", "300", "400", "500"};
    private Combo comboResolution;
    private Combo comboHeight;
    private Combo comboWidth;
    private ModifyListener comboResolutionModifyListener;
    private ModifyListener comboWidthModifyListener;
    private ModifyListener comboHeightModifyListener;
    private Label labelHeight;
    private Label labelWidth;
    private Button radioResolution;
    private Button radioHeight;
    private Button radioWidth;
    private Button radioBothDimensions;
    private Button transparency;
    private final DoublePattern resolutionPattern = new DoublePattern(0.01, 9600.0, false);
    private final DoublePattern dimensionPattern = new DoublePattern(1.0, 100000.0, true);
    private final SaveAsPNGDialogSettings settingsCopy;
    private final SaveAsPNGDialogSettings settings;

    public SaveAsPNGDialog(Shell parent, InternalDialogSettings internalSettings, SaveAsPNGDialogSettings settings, IEditorContent editorContent) {
        super(parent, internalSettings, editorContent);
        this.settingsCopy = new SaveAsPNGDialogSettings(settings);
        this.settings = settings;
        this.errors = new String[20][2];
        this.warnings = new String[20];
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IHelpContextIDs.EDITOR_IMAGEEXPORTDIALOG);
        return super.createDialogArea(parent);
    }

    @Override
    protected AbstractSaveAsDialogSettings getSaveAsDialogSettings() {
        return this.settingsCopy;
    }

    @Override
    protected String getFileExtension() {
        return "png";
    }

    @Override
    protected String saveAs() {
        ImagePrinter printer = (ImagePrinter)this.createPrinter();
        PrintingFailure failure = this.print((IPrinter)printer);
        if (failure == null) {
            this.getShell().setCursor(Cursors.WAIT);
            try {
                printer.saveImageDirectly(this.settingsCopy.getFile(), ImageCoDec.PNG);
            }
            catch (PrintingFailure e) {
                failure = e;
            }
            catch (EXEmptyResult e) {
                failure = new PrintingFailure((Throwable)e);
            }
            this.getShell().setCursor(Cursors.ARROW);
        }
        this.disposePrinter((IPrinter)printer);
        String errorMsg = null;
        if (failure != null) {
            errorMsg = failure.getCause() instanceof EXImageTooBig ? Messages.getString("SaveAsImageDialog.Image_Too_Big") : Messages.getString("SaveAsImageDialog.Print_Failure_Text");
        }
        return errorMsg;
    }

    @Override
    protected Group addCustomGroup(Composite leftArea) {
        Group customGroup = new Group(leftArea, 0);
        customGroup.setText(GROUP_NAME);
        GridData gridData = new GridData(768);
        customGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        customGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.radioResolution = new Button((Composite)customGroup, 16);
        this.radioResolution.setText(PIXELS_LABEL_DPI);
        this.radioResolution.setLayoutData((Object)gridData);
        this.radioResolution.setSelection(this.settingsCopy.getMode() == 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.comboResolution = new Combo((Composite)customGroup, 4);
        this.comboResolution.setItems(PIXELS_ITEMS_DPI);
        this.updateResolution();
        this.comboResolution.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioWidth = new Button((Composite)customGroup, 16);
        this.radioWidth.setText(WIDTH_LABEL1);
        this.radioWidth.setLayoutData((Object)gridData);
        this.radioWidth.setSelection(this.settingsCopy.getMode() == 2);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioHeight = new Button((Composite)customGroup, 16);
        this.radioHeight.setText(HEIGHT_LABEL1);
        this.radioHeight.setLayoutData((Object)gridData);
        this.radioHeight.setSelection(this.settingsCopy.getMode() == 1);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioBothDimensions = new Button((Composite)customGroup, 16);
        this.radioBothDimensions.setText(DIMENSIONS_LABEL);
        this.radioBothDimensions.setLayoutData((Object)gridData);
        this.radioBothDimensions.setSelection(this.settingsCopy.getMode() == 3);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 2;
        this.labelWidth = new Label((Composite)customGroup, 16384);
        this.labelWidth.setText(WIDTH_LABEL2);
        this.labelWidth.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.comboWidth = new Combo((Composite)customGroup, 4);
        this.comboWidth.setItems(DIMENSIONS_ITEMS);
        this.comboWidth.setText(Integer.valueOf(this.settingsCopy.getWidthPxl()).toString());
        this.comboWidth.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 2;
        this.labelHeight = new Label((Composite)customGroup, 16384);
        this.labelHeight.setText(HEIGHT_LABEL2);
        this.labelHeight.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.comboHeight = new Combo((Composite)customGroup, 4);
        this.comboHeight.setItems(DIMENSIONS_ITEMS);
        this.comboHeight.setText(Integer.valueOf(this.settingsCopy.getHeightPxl()).toString());
        this.comboHeight.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.transparency = new Button((Composite)customGroup, 32);
        this.transparency.setText(Messages.getString("SaveAsImageDialog.BackgroundTransparency"));
        this.transparency.setSelection(this.settingsCopy.isBackgroundTransparent());
        this.transparency.setLayoutData((Object)gridData);
        this.radioResolution.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SaveAsPNGDialog.this.radioResolution.getSelection()) {
                    SaveAsPNGDialog.this.toggleWidgets();
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.radioHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SaveAsPNGDialog.this.radioHeight.getSelection()) {
                    SaveAsPNGDialog.this.toggleWidgets();
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.radioWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SaveAsPNGDialog.this.radioWidth.getSelection()) {
                    SaveAsPNGDialog.this.toggleWidgets();
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.radioBothDimensions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SaveAsPNGDialog.this.radioBothDimensions.getSelection()) {
                    SaveAsPNGDialog.this.toggleWidgets();
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            }
        });
        this.transparency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveAsPNGDialog.this.refresh();
            }
        });
        return customGroup;
    }

    @Override
    protected String getExtendedErrorMessage(int index) {
        String toReturn;
        switch (index) {
            case 13: {
                toReturn = Messages.getString("SaveAsImageDialog.You_have_entered_an_invalid_value_combinations_into_the_dimension_fields");
                break;
            }
            case 14: {
                toReturn = Messages.getString("SaveAsImageDialog.You_have_entered_an_invalid_value_into_the_height_field");
                break;
            }
            case 15: {
                toReturn = Messages.getString("SaveAsImageDialog.You_have_entered_an_invalid_value_into_the_width_field");
                break;
            }
            case 16: {
                toReturn = Messages.getString("SaveAsImageDialog.The_resulting_resolution_will_be_invalid._Please_change_your_settings");
                break;
            }
            case 17: {
                toReturn = Messages.getString("SaveAsImageDialog.You_have_entered_an_invalid_value_into_the_resolution_field");
                break;
            }
            default: {
                toReturn = super.getExtendedErrorMessage(index);
            }
        }
        return toReturn;
    }

    @Override
    protected String getStdMessage() {
        return MESSAGE;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    public void create() {
        super.create();
        this.toggleWidgets();
    }

    private void toggleWidgets() {
        if (this.radioResolution.getSelection()) {
            this.comboResolution.setEnabled(true);
            this.comboHeight.setEnabled(false);
            this.comboWidth.setEnabled(false);
        } else if (this.radioHeight.getSelection()) {
            this.comboResolution.setEnabled(false);
            this.comboHeight.setEnabled(true);
            this.comboWidth.setEnabled(false);
        } else if (this.radioWidth.getSelection()) {
            this.comboResolution.setEnabled(false);
            this.comboHeight.setEnabled(false);
            this.comboWidth.setEnabled(true);
        } else if (this.radioBothDimensions.getSelection()) {
            this.comboResolution.setEnabled(false);
            this.comboHeight.setEnabled(true);
            this.comboWidth.setEnabled(true);
        }
        if (!this.comboResolution.isEnabled() && this.comboResolutionModifyListener != null) {
            this.comboResolution.removeModifyListener(this.comboResolutionModifyListener);
            this.comboResolutionModifyListener = null;
        } else if (this.comboResolution.isEnabled() && this.comboResolutionModifyListener == null) {
            this.comboResolutionModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            };
            this.comboResolution.addModifyListener(this.comboResolutionModifyListener);
        }
        if (!this.comboWidth.isEnabled() && this.comboWidthModifyListener != null) {
            this.comboWidth.removeModifyListener(this.comboWidthModifyListener);
            this.comboWidthModifyListener = null;
        } else if (this.comboWidth.isEnabled() && this.comboWidthModifyListener == null) {
            this.comboWidthModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            };
            this.comboWidth.addModifyListener(this.comboWidthModifyListener);
        }
        if (!this.comboHeight.isEnabled() && this.comboHeightModifyListener != null) {
            this.comboHeight.removeModifyListener(this.comboHeightModifyListener);
            this.comboHeightModifyListener = null;
        } else if (this.comboHeight.isEnabled() && this.comboHeightModifyListener == null) {
            this.comboHeightModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SaveAsPNGDialog.this.frameViewConfigChanged();
                }
            };
            this.comboHeight.addModifyListener(this.comboHeightModifyListener);
        }
    }

    @Override
    public IPrinter createPrinter() {
        double wInMM = 25.4 * (double)this.settingsCopy.getWidthPxl() / this.settingsCopy.getHorizontalDPI();
        double hInMM = 25.4 * (double)this.settingsCopy.getHeightPxl() / this.settingsCopy.getVerticalDPI();
        Color backgroundColor = this.settingsCopy.isBackgroundTransparent() ? Color.TRANSPARENT : Color.WHITE;
        return new ImagePrinter(ImagePrinterPageDescription.createImageInfoInMM((double)wInMM, (double)hInMM, (Insets)new Insets(0.0, 0.0, 0.0, 0.0), (double)this.settingsCopy.getHorizontalDPI(), (double)this.settingsCopy.getVerticalDPI(), (Color)backgroundColor));
    }

    @Override
    public void disposePrinter(IPrinter printer) {
        ((ImagePrinter)printer).disposeImages();
    }

    @Override
    protected AbstractPreviewDialogSettings getSettings() {
        return this.settingsCopy;
    }

    @Override
    protected void readWidgetValues() {
        super.readWidgetValues();
        this.removeErrors(17);
        this.removeErrors(14);
        this.removeErrors(15);
        if (this.radioResolution.getSelection()) {
            this.settingsCopy.setMode(0);
            Double parsedResolutionInDPI = this.parseInput(this.comboResolution.getText(), this.resolutionPattern, 17);
            if (parsedResolutionInDPI != null) {
                this.settingsCopy.setHorizontalDPI(parsedResolutionInDPI);
                this.settingsCopy.setVerticalDPI(parsedResolutionInDPI);
            }
        } else if (this.radioHeight.getSelection()) {
            this.settingsCopy.setMode(1);
            Double parsedHeight = this.parseInput(this.comboHeight.getText(), this.dimensionPattern, 14);
            if (parsedHeight != null) {
                this.settingsCopy.setHeightPxl(parsedHeight.intValue());
            }
        } else if (this.radioWidth.getSelection()) {
            this.settingsCopy.setMode(2);
            Double parsedWidth = this.parseInput(this.comboWidth.getText(), this.dimensionPattern, 15);
            if (parsedWidth != null) {
                this.settingsCopy.setWidthPxl(parsedWidth.intValue());
            }
        } else if (this.radioBothDimensions.getSelection()) {
            this.settingsCopy.setMode(3);
            Double parsedWidth = this.parseInput(this.comboWidth.getText(), this.dimensionPattern, 15);
            Double parsedHeight = this.parseInput(this.comboHeight.getText(), this.dimensionPattern, 14);
            if (parsedWidth != null && parsedHeight != null) {
                this.settingsCopy.setHeightPxl(parsedHeight.intValue());
                this.settingsCopy.setWidthPxl(parsedWidth.intValue());
            }
        }
        this.settingsCopy.setBackgroundTransparent(this.transparency.getSelection());
    }

    @Override
    protected void updateSettings() {
        switch (this.settingsCopy.getMode()) {
            case 0: {
                this.settingsCopy.setDimensionsForResolution(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
                break;
            }
            case 1: {
                this.settingsCopy.setWidthForHeight(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
                this.settingsCopy.setResolutionForDimensions(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
                break;
            }
            case 2: {
                this.settingsCopy.setHeightForWidth(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
                this.settingsCopy.setResolutionForDimensions(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
                break;
            }
            case 3: {
                this.settingsCopy.setResolutionForDimensions(this.getMinimalOuterBoundsInMM().expand(this.settingsCopy.getPageSetup().getMargin()).getDimension());
                break;
            }
        }
        long estimatedImageSize = (long)this.settingsCopy.getWidthPxl() * (long)this.settingsCopy.getHeightPxl() * 4L;
        Runtime runtime = Runtime.getRuntime();
        long allocateableMemory = runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
        this.errors[18][1] = (double)estimatedImageSize * 2.1 > (double)allocateableMemory ? String.valueOf(ERROR_IMAGE_SIZE1) + estimatedImageSize / 1000000L + ERROR_IMAGE_SIZE2 : null;
        this.warnings[13] = estimatedImageSize > 8000000L ? String.valueOf(WARNING_IMAGE_SIZE1) + estimatedImageSize / 1000000L + WARNING_IMAGE_SIZE2 : null;
        super.updateSettings();
    }

    @Override
    protected void writeWidgetValues() {
        super.writeWidgetValues();
        this.checkErrors(this.settingsCopy.getHorizontalDPI(), this.resolutionPattern, 17);
        this.checkErrors(this.settingsCopy.getWidthPxl(), this.dimensionPattern, 15);
        this.checkErrors(this.settingsCopy.getHeightPxl(), this.dimensionPattern, 14);
        switch (this.settingsCopy.getMode()) {
            case 0: {
                this.comboHeight.setText(Integer.valueOf(this.settingsCopy.getHeightPxl()).toString());
                this.comboWidth.setText(Integer.valueOf(this.settingsCopy.getWidthPxl()).toString());
                break;
            }
            case 1: {
                this.comboWidth.setText(Integer.valueOf(this.settingsCopy.getWidthPxl()).toString());
                this.updateResolution();
                break;
            }
            case 2: {
                this.comboHeight.setText(Integer.valueOf(this.settingsCopy.getHeightPxl()).toString());
                this.updateResolution();
                break;
            }
            case 3: {
                this.updateResolution();
                break;
            }
        }
    }

    private void updateResolution() {
        double dpi = this.settingsCopy.getHorizontalDPI();
        this.comboResolution.setText(LocalisationUtils.roundLocalized((double)dpi, (int)0, (boolean)true));
    }

    @Override
    protected FrameViewConfig getFrameViewConfig(PageInfo pageInfo) {
        FrameViewConfig frameViewConfig;
        switch (this.settingsCopy.getMode()) {
            case 0: {
                frameViewConfig = FrameViewConfig.createFrame((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)1.0);
                break;
            }
            case 1: {
                frameViewConfig = FrameViewConfig.createFrame((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)1.0);
                break;
            }
            case 2: {
                frameViewConfig = FrameViewConfig.createFrame((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)1.0);
                break;
            }
            case 3: {
                frameViewConfig = FrameViewConfig.createFrameExpandedToPageBorders((Insets)this.settingsCopy.getInnerMargins(), (double)10.0, (double)1.0, (PageInfo)pageInfo);
                break;
            }
            default: {
                frameViewConfig = null;
            }
        }
        return frameViewConfig;
    }

    @Override
    protected int limitPreviewPageWidth(int wishInPixels) {
        return Math.min(wishInPixels, this.settingsCopy.getWidthPxl());
    }

    @Override
    protected int limitPreviewPageHeight(int wishInPixels) {
        return Math.min(wishInPixels, this.settingsCopy.getHeightPxl());
    }

    @Override
    protected boolean printerDefinesPrintingArea() {
        return false;
    }

    @Override
    protected void okPressed() {
        this.settings.copyFrom(this.settingsCopy);
        super.okPressed();
    }

    @Override
    protected boolean isAlignmentAreaToBeEnabled() {
        boolean enable = true;
        enable &= this.settingsCopy.getMode() == 3;
        return enable &= super.isAlignmentAreaToBeEnabled();
    }
}

