/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AbstractUIPlanElementAction;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.inputinterpreter.IIUtilities;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class UIChangeDescriptionAction
extends AbstractUIPlanElementAction {
    public static final String ID = "de.plans.fmca.planagent.actions.uichangedescriptionaction";
    private static final ILogger logger = Logger.getLogger(UIChangeDescriptionAction.class);

    public UIChangeDescriptionAction(ContextMenuContext context) {
        super(context);
        if (logger.isTraceEnabled()) {
            logger.trace("UIChangeDescriptionAction(ContextMenuContext context = " + context + ") - start");
        }
        this.setup();
        this.update();
        if (logger.isTraceEnabled()) {
            logger.trace("UIChangeDescriptionAction(ContextMenuContext) - end");
        }
    }

    private void setup() {
        this.setText(Messages.getString("UIChangeDescriptionAction.ChangeDescription"));
        this.setToolTipText(Messages.getString("UIChangeDescriptionAction.Change_description_of_the_currently_selected_element"));
        this.setId(ID);
    }

    protected void init() {
        super.init();
        this.setup();
    }

    protected boolean calculateEnabled() {
        PEPlanElement po;
        boolean toReturn = false;
        List<PEPlanElement> selectedPEs = this.getSelectedPlanElements();
        if (selectedPEs.size() == 1 && (po = selectedPEs.get(0)).isRenameable()) {
            toReturn = true;
        }
        return toReturn;
    }

    public String getPreferedMenuGroup() {
        return "com.arcway.cockpit.planagent.planeditor.contextmenu.planelement";
    }

    @Override
    protected Command getCommand(List<PEPlanElement> items) {
        assert (items != null) : "items is null";
        if (this.calculateEnabled() && !items.isEmpty()) {
            IInputContext ctx = (IInputContext)this.getWorkbenchPart().getAdapter(IInputContext.class);
            if (ctx == null) {
                return null;
            }
            return IIUtilities.createCMChangeDescriptionCommand(items.get(0), super.getCommandContext());
        }
        return null;
    }

    @Override
    protected Class<? extends IPMPlanElementRO> getIPlanElementROType() {
        return null;
    }

    @Override
    protected boolean isVisibleIfDisabled() {
        return false;
    }

    @Override
    protected boolean isVisibleInProjectionMode() {
        return false;
    }
}

