/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.geometry.snap.Grid;
import com.arcway.planagent.IInternalAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.planeditor.ActionParameterStorage;
import com.arcway.planagent.planeditor.IPlanEditorConfig;
import com.arcway.planagent.planeditor.PlanEditorConstants;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IToolChangedListener;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.swt.widgets.Display;

public class PlanEditorEditDomain
extends EditDomain
implements ICommandContext {
    private static final int UNDO_LIMIT = 10000;
    private final IPlanEditorControllerExtension controllerExtension;
    private final IInternalAbstractPlanAgent planController;
    private final List<IToolChangedListener> toolChangedListeners;
    private final Display display;
    private final Grid grid;

    public PlanEditorEditDomain(Display display, IPlanEditorControllerExtension controllerExtension, IInternalAbstractPlanAgent planController, IPlanEditorConfig config) {
        assert (display != null);
        assert (controllerExtension != null);
        assert (planController != null);
        this.display = display;
        this.controllerExtension = controllerExtension;
        this.planController = planController;
        this.toolChangedListeners = new ArrayList<IToolChangedListener>();
        this.grid = new Grid(PlanEditorConstants.DEFAULT_GRID_ORIGIN, config.getDefaultGridWidth(), config.getDefaultGridHeight());
        this.getCommandStack().setUndoLimit(10000);
    }

    public Display getDisplay() {
        return this.display;
    }

    @Override
    public ActionParameters getActionParameters() {
        return ActionParameterStorage.getInstance().getActionParameters();
    }

    public void setActiveTool(Tool tool) {
        Tool oldTool = this.getActiveTool();
        if (oldTool instanceof GenericTool && tool instanceof GenericTool) {
            ((GenericTool)tool).copyStateFrom((GenericTool)oldTool);
        }
        super.setActiveTool(tool);
        this.fireToolChangedEvent();
    }

    public void addToolChangedListener(IToolChangedListener itcl) {
        this.toolChangedListeners.add(itcl);
    }

    public void removeToolChangedListener(IToolChangedListener itcl) {
        this.toolChangedListeners.remove(itcl);
    }

    private void fireToolChangedEvent() {
        if (this.toolChangedListeners != null && !this.toolChangedListeners.isEmpty()) {
            Iterator<IToolChangedListener> iterator = this.toolChangedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().toolChanged(super.getActiveTool());
            }
        }
    }

    @Override
    public Grid getGrid() {
        return this.grid;
    }

    @Override
    public IPlanEditorControllerExtension getEditorController() {
        return this.controllerExtension;
    }

    @Override
    public IInternalAbstractPlanAgent getInternalPlanController() {
        return this.planController;
    }
}

