/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.planagent.planeditor.FMCAPlanEditorCommonPlugin;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.cm.Messages;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextStyleAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextStyleAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class TextVariantItalicDecoration
implements IAppearanceButtonDecoration {
    private static TextVariantItalicDecoration instance = new TextVariantItalicDecoration();
    private static ImageDescriptor italicImage = TextVariantItalicDecoration.createImageDescriptor();

    public static TextVariantItalicDecoration getInstance() {
        return instance;
    }

    private static ImageDescriptor createImageDescriptor() {
        ImageDescriptor loaded = ResourceLoader.getImageDescriptor((String)"cm/textvariant_italic.gif", (Plugin)FMCAPlanEditorCommonPlugin.getDefault());
        return loaded;
    }

    public Class[] getAppearanceClasses() {
        return new Class[]{ITextAppearanceRO.class};
    }

    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ITextAppearanceRO)appearance).getTextStyle().isItalic();
    }

    public String getToolTipText(Object state) {
        return (Boolean)state != false ? Messages.getString("TextVariantItalicDecoration.Italic") : Messages.getString("TextVariantItalicDecoration.Regular");
    }

    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return italicImage;
    }

    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        boolean isItalic = (Boolean)state == false;
        TextAppearanceTpl template = new TextAppearanceTpl();
        TextStyleAppearanceTpl subTpl = new TextStyleAppearanceTpl();
        subTpl.setItalic(isItalic);
        template.setTextStyleTpl((ITextStyleAppearanceTpl)subTpl);
        return new IAppearanceTpl[]{template};
    }
}

