/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.base.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.base.Messages;
import com.arcway.planagent.planeditor.base.actions.UIAbstractStickmanAction;
import com.arcway.planagent.planeditor.base.commands.CMDeleteStickman;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithStickmanSupplementRO;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class UIDeleteStickmanAction
extends UIAbstractStickmanAction {
    private static final ILogger logger = Logger.getLogger(UIDeleteStickmanAction.class);
    private static final String ID = "de.plans.fmca.planagent.planeditor.base.actions.uideletestickman";

    public UIDeleteStickmanAction(ContextMenuContext context) {
        super(context);
        if (logger.isTraceEnabled()) {
            logger.trace("UiDeleteStickmanAction(ContextMenuContext context = " + context + ") - start");
        }
        this.setText(Messages.getString("UIDeleteStickmanAction.Delete_Stickman"));
        this.setToolTipText(Messages.getString("UIDeleteStickmanAction.Deletes_the_stickman_of_the_current_agent"));
        this.setId(ID);
        if (logger.isTraceEnabled()) {
            logger.trace("UiDeleteStickmanAction(ContextMenuContext) - end");
        }
    }

    protected boolean calculateEnabled() {
        IPMPlanElementWithStickmanSupplementRO agent;
        boolean toReturn = false;
        if (this.getSelectedAgent() != null && (agent = this.getSelectedAgent()).getStickmanRO() != null) {
            toReturn = true;
        }
        return toReturn;
    }

    protected Command getCommand(List<PEPlanElement> items) {
        assert (items != null) : "items is null";
        if (this.calculateEnabled() && !items.isEmpty()) {
            IPMPlanElementWithStickmanSupplementRO agent = (IPMPlanElementWithStickmanSupplementRO)items.get(0).getModel();
            return new CMDeleteStickman(agent, super.getCommandContext());
        }
        return null;
    }

    protected boolean isVisibleIfDisabled() {
        return false;
    }

    protected boolean isVisibleInProjectionMode() {
        return false;
    }
}

