/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.base.actions;

import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.resource.URLResource;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.actions.AbstractUIPlanElementAction;
import com.arcway.planagent.planeditor.base.edit.IPEPlanElementWithImageSupplement;
import com.arcway.planagent.planeditor.cm.Messages;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.FMCAPlanModelCommonPlugin;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithImageSupplementRO;
import de.plans.lib.eclipse.ResourceLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public abstract class UIAbstractImageAction
extends AbstractUIPlanElementAction {
    static final IStreamResource ERROR_IMAGE;

    static {
        try {
            URL url = ResourceLoader.getUrl((Plugin)FMCAPlanModelCommonPlugin.getDefault(), (String)"icons/missingImg.png");
            URLResource streamResource = new URLResource(url);
            byte[] pngByteArray = ImageCoDec.loadIntoPNGOrJPGByteArray((IStreamResource)streamResource);
            File tmpFile = SessionTempDirectoryManager.createSessionTempFile((String)"planeditorimage", null);
            FileOutputStream os = new FileOutputStream(tmpFile);
            os.write(pngByteArray);
            os.close();
            ERROR_IMAGE = new FileResource(tmpFile);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public UIAbstractImageAction(ContextMenuContext context) {
        super(context);
    }

    public String getPreferedMenuGroup() {
        return "com.arcway.cockpit.planagent.planeditor.contextmenu.planelement";
    }

    protected Class<? extends IPMPlanElementRO> getIPlanElementROType() {
        return IPMPlanElementWithImageSupplementRO.class;
    }

    protected boolean calculateEnabled() {
        return this.getSelectedPlanElementWithImage() != null;
    }

    protected IPMPlanElementWithImageSupplementRO getSelectedPlanElementWithImage() {
        return this.getSelectedPlanElementWithImage(this.getSelectedPlanElements());
    }

    protected IPMPlanElementWithImageSupplementRO getSelectedPlanElementWithImage(List<PEPlanElement> selection) {
        IPMPlanElementWithImageSupplementRO agent = selection.size() == 1 ? (IPMPlanElementWithImageSupplementRO)((PEPlanElement)((IPEPlanElementWithImageSupplement)selection.get(0))).getModel() : null;
        return agent;
    }

    protected IPEPlanElementWithImageSupplement getSelectedPEPlanElementWithImage() {
        List selection = this.getSelectedPlanElements();
        IPEPlanElementWithImageSupplement planElement = selection.size() == 1 ? (IPEPlanElementWithImageSupplement)selection.get(0) : null;
        return planElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStreamResource loadIntoTempFile(IStreamResource streamResource) {
        try {
            Image image = ImageCoDec.decodeIntoImage((IStreamResource)streamResource);
            try {
                FileResource pngByteArrayAsStreamResource;
                int w = image.getWidthInPixels();
                int h = image.getHeightInPixels();
                if ((long)(w * h) > 3048192L) {
                    Image scaledImage = Image.scaleImage((Image)image, (long)3048192L);
                    image.dispose();
                    image = scaledImage;
                }
                File tmpFile = SessionTempDirectoryManager.createSessionTempFile((String)"planeditorimage", null);
                ImageCoDec.encodeIntoFile((Image)image, (File)tmpFile, (ImageFileType)ImageCoDec.PNG);
                FileResource fileResource = pngByteArrayAsStreamResource = new FileResource(tmpFile);
                return fileResource;
            }
            catch (EXImageDataTypeNotSupported e) {
                this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXImageDataTypeNotSupported_Cause"));
                IStreamResource iStreamResource = ERROR_IMAGE;
                return iStreamResource;
            }
            catch (EXNoMoreHandles e) {
                this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXNoMoreHandles_Cause"));
                IStreamResource iStreamResource = ERROR_IMAGE;
                return iStreamResource;
            }
            catch (JvmExternalResourceInteractionException e) {
                this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.JvmExternalResourceIneractionException_Cause"));
                IStreamResource iStreamResource = ERROR_IMAGE;
                return iStreamResource;
            }
            catch (EXImageTooBig e) {
                this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXImageTooBig_Cause"));
                IStreamResource iStreamResource = ERROR_IMAGE;
                return iStreamResource;
            }
            finally {
                image.dispose();
            }
        }
        catch (EXImageDataTypeNotSupported e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXImageDataTypeNotSupported_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXUnsupportedColorDepth e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXUnsupportedColorDepth_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXNoMoreHandles e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXNoMoreHandles_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXCorruptImageFileContent e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXCorruptImageFileContent_Cause"));
            return ERROR_IMAGE;
        }
        catch (JvmExternalResourceInteractionException e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.JvmExternalResourceIneractionException_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXUnspecifiedImageLoadingError e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXUnspecifiedImageLoadingError_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXImageTooBig e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXImageTooBig_Cause"));
            return ERROR_IMAGE;
        }
    }

    private void openErrorDialog(final String descriptionOfCause) {
        IModificationProblem problem = new IModificationProblem(){

            public String getHumanReadableDescriptionOfCause() {
                return descriptionOfCause;
            }

            public String getHumanReadableDescriptionOfConsequence() {
                return Messages.getString("AbstractImageSupplementEditPolicy.GeneralErrorDescription");
            }

            public int getSeverity() {
                return 2;
            }
        };
        Set<1> modificationProblems = Collections.singleton(problem);
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(modificationProblems, this.getShell());
        dialog.open();
    }
}

